#include <stdio.h>
#include <string.h>
#include <bios.h>
#include <conio.h>
#include <dos.h>
#include <time.h>
#include <stdlib.h>


// Global Defines
#define TRUE 1
#define FALSE 0
#define GOOD 10
#define BAD 11 
#define ESCAPE 0x1B
#define CTRL_X 0x18
#define TIMEOUT 14
#define FATAL_ERROR 15
#define SUCCESS 16
#define BUFFER_EMPTY 17
#define ENTER 0x0D
#define SPACE 0x20
#define LEFT 202 //0xFFCA
#define RIGHT 204 //0xFFCC
#define UP 199 //0xFFC7
#define DOWN 207 //0xFFCF
#define SHIFT_UP 133 //0xFF85
#define SHIFT_DOWN 136 //0xFF88
#define SHIFT_LEFT 134 //0xFF86
#define SHIFT_RIGHT 135 //0xFF87
#define NORMAL_EXIT 19
#define ERROR 20
#define OPTOCOM 22
#define OPTOSCAN 23
#define OPEN 24
#define CLOSED 25
#define SWEEP 26
#define VFO 27
#define DCS 28
#define LTR 29
#define DONE 30
#define TEN_KHZ 33
#define ONE_KHZ 34
#define HUNDRED_HZ 35
#define TEN_HZ 36
#define FREQUENCY_RANGE_ERROR 37
#define FREQUENCY_MULTIPLE_ERROR 38
#define NFM 39
#define WFM 40
#define AM 41
#define VOLUME 42
#define SQUELCH 43



#define TIMEOUT_VALUE 5
#define S 2000


#define RECV_XMIT 0
#define INT_ENABLE 1
#define INT_IDENT 2
#define LINE_CONTROL 3
#define MODEM_CONTROL 4
#define LINE_STATUS 5
#define MODEM_STATUS 6
#define COM1 0x3F8
#define COM2 0x2F8
#define COM3 0x3E8
#define COM4 0x2E8
#define R9600 0
#define R4800 1
#define R2400 2
#define R1200 3
#define R300 4
#define COL1 27
#define COL2 40

// Global variables

int temp = 0;

unsigned char command[256];
unsigned char response[256];

int txhp = 0;                  
int txtp = 0;                  
int rxhp = 0;                  
char frequency[20];

clock_t timer_start;
clock_t timer_stop;
int base = COM1;		         /* Serial port base address.  */
int rate = R9600;		         /* Serial port data rate.     */


int address = 0x00;  // address of device currently connected
int echo_flag = 0;   // to tell if an echo came back

unsigned char id[3];

char sv[4];
char rv[4];
char iv[4];
char signal[4]; // Signal Strength
char ctcss[6];  // CTCSS tone
char dcs[4];    // DCS tone
char dtmf_digit = 0; // DTMF digit
char ltr_area[2];
char ltr_goto[3];
char ltr_home[3];
char ltr_id[4];
char ltr_free[3];
char volume_setting[4];
char squelch_setting[5];
char serial_number[20];
char key_buf[13];
int input_error = 0; // used in get_input routine

int dtmf_pending = 0;
int volume_squelch_control_status = 0;
int dtmf_overrun = 0;
int squelch_status = 0;
int ctcss_active = 0;
int nrz_active = 0;
int tape_control = 0;
int speaker_control = 0;
int search_window = 0;
int audio_status = 0;
int search_mode = 0;
int frequency_received = 0;
int mode_received = 0;
int pipeline_received = 0;
int nrz_mode = DCS;
int gate_time = 0;
unsigned long n_frequency = 0;
int volume_squelch_control_indicator = VOLUME;
unsigned char keybuffer[256]; 
int kbhp = 0;
int kbtp = 0;
int bordercolor = LIGHTBLUE;
int mainfields = LIGHTGREEN;
int device; // Identifies which device is hooked up
int count = 0; // Used by product layer timeout routine
int previous = SUCCESS; // Used by product layer timeout routine
int intermittent_message_showing = FALSE;
int pos = 0; 
char dtmf_buffer[70];
char temp_dtmf_digit;
int dtmf_buffer_pointer = 0;
clock_t now, last_dtmf_call;
int entry = 0; // indicates that user is in input mode
int scan_mode = 0;
int mode = NFM;

// Added for 2.0
int cellular_capable = 0;
int expected = 0;
int spinner = 0;
int MemoryZeroEmpty;
int exit_request = 0;

// function prototypes

int comm_loop(void);
int comm_timer(void);
int get_byte(void);
void Extract_versions(void);
int Optocom_layer(void);
int Write_volume(int value);
int Write_squelch(int value);
int read_kb(void);
void send_byte(void);
int read_id(void);
int search_for_product(void);
int Read_frequency(void);
void timeout(int response);
int Write_frequency(long freq);
void Send_command(void);
int Read_signal_strength(void);
int Enable_tape_recorder(void);
int Disable_tape_recorder(void);
int Read_CTCSS(void);
int Read_DCS(void);
int Read_DTMF_digit(void);
int Enable_speaker_audio(void);
int Disable_speaker_audio(void);
int Enable_DCS_mode(void);
int Enable_LTR_mode(void);
int Enable_AM_mode(void);
int Enable_NFM_mode(void);
int Enable_WFM_mode(void);
int Enable_remote_volume_squelch_mode(void);
int Enable_local_volume_squelch_mode(void);
int Get_serial_digit(void);
int Get_serial_number(void);
void clr_ol_fields(void);
int get_input(int x, int y);
int get_id(void);
int Read_status(void);
void Initialize(void);
int Get_frequency(int x, int y);
int Optocom_direct_frequency_entry(void);
void show_time(void);
void scan_kb(void);
void dtmf(void);
int Get_serial_digit(void);
int Read_LTR_data(void);
int Switch_Optocom_mode(void);
int Enable_scan_mode(void);
int Disable_scan_mode(void);
int Store_operating_parameters(void);
void display_title(void);                 /* Displays program title        */
void display_dialog(void);                /* Creates dialog box on screen  */
void select_port(void);                   /* Gets user input and sets port */
void initialize_port(void);               /* Initializes selected port     */
void border(void);

// Added in 2.0
void initialize_screen(void);
int reads(void);
void update_display(void);
int keyboard_entry(void);
int scan_keys(void);
int Read_mode(void);
void update_spinner(void);


class Field
{
	 public:

// Constructor
Field(char *pIncoming = " ", 
	 int x = 0, 
	 int y = 0, 
	 int fore = WHITE, 
	 int back = BLACK)
 {


	// Validate incoming values
	if (x < 0)
	{
		x = 0;
	}
	if (x > 79)
	{
	    x = 0;
	} 
	if ( x < 0)
	{
	    x = 0;
	} 
	if (y > 25)
	{
	    y = 0;
	} 
	if (y <0)
	{
	    y = 0;
	} 

	if (fore < BLACK)
	{
	    fore = WHITE + BLINK;
	    back = RED;
	} 

	if (fore > WHITE)
	{
		if( (fore < BLINK) || (fore > (BLINK + WHITE)) )
		{
			fore = WHITE + BLINK;
			back = RED;
		} 
	} 
	if (back < BLACK)
	{
		fore = fore + BLINK;
		back = RED;
	} 

	if (back > WHITE)
	{
		if ( (back < BLINK) || (back > (BLINK + WHITE)) )
		{
			fore = fore + BLINK;
			back = RED;
		} 
	}
	

   //Copy incoming values to protected members
   x_location = x;
   y_location = y;
   fgcolor = fore;
   bgcolor = back;
   strncpy(incoming, pIncoming, sizeof(incoming));
   incoming[sizeof(incoming) - 1] = '\0';
   
   // Show field
   Show();

	 

 } 

 


// Destructor
 ~Field()
 {
 }

 void Show()
 {
   gotoxy(x_location,y_location);
   textcolor(fgcolor);
   textbackground(bgcolor);
   cprintf("%s", incoming);
 }

 void Remove()
 {
   gotoxy(x_location,y_location);
   textcolor(BLACK);
   textbackground(BLACK);
   cprintf("%s", incoming);
 }
 
 void Text(char *pIncoming)
 {
   Remove();
   strncpy(incoming, pIncoming, sizeof(incoming));
   incoming[sizeof(incoming) - 1] = '\0';
   Show();
 }

 void Locate(int x, int y)
 {
	 if (x > 79)
	 {
		 x = 0;
	 }
	 if ( x < 0)
	 {
		 x = 0;
	 }
	 if (y > 25)
	 {
		 y = 0;
	 }
	 if (y < 0)
	 {
		 y = 0;
	 }

	 // Remove old one
	 Remove();

	 // Set new location
	 x_location = x;
	 y_location = y;
	 
	 // Show new one
	 Show();
 }

 void Color(int fore = WHITE, int back= BLACK)
 {
	 if (fore < BLACK)
	 {
		 fore = WHITE;
	 }

	 if (fore > WHITE)
	 {
		 if( (fore < BLINK) || (fore > (BLINK + WHITE)) )
		 {
			 fore = WHITE;
		 }
	 }
	 if (back < BLACK)
	 {
		 back = BLACK;
	 }

	 if (back > WHITE)
	 {
		 if ( (back < BLINK) || (back > (BLINK + WHITE)) )
		 {
			 back = BLACK;
		 }
	 }

	 // Remove old one
	 Remove();

	 // Set new color
	 fgcolor = fore;
	 bgcolor = back;
	 
	 // Show new one
	 Show();
 }

 void Highlight(char h = '', int hc = WHITE) 

 {
	 int l; // temp variable

	 if (h == '')
	 {
		 return;
	 }

	 if (hc < BLACK)
	{
	    highlight_color = WHITE;
	} 

	if (hc > WHITE)
	{
		if( (hc < BLINK) || (hc > (BLINK + WHITE)) )
		{
			highlight_color = WHITE;
			
		} 
	}

   
   l = find_highlight_character(h);
   if (l != 999)
   {
	  x_offset = l;
	  gotoxy((x_location + x_offset), y_location);
	  textcolor(hc);
	  cprintf("%c", h);
   }



 }




 protected:
 char incoming[79]; // change length if needed
 int fgcolor;
 int bgcolor;
 int x_location;
 int y_location;
 char highlight;
 int highlight_color;
 int highlight_location;
 int x_offset;
 
 int find_highlight_character(char h)
 {
	 int l; // used for loop
	 for (l = 0; l <= sizeof(incoming); l++)
	 {
		 if (incoming[l] == h)
		 {
			 return l;
		 }
		 if (incoming[l] == '/0')
		 {
			 return 999;
		 }
	 }
 }


};//endofclass

/// Create Global Fields

// Top Row Fields
Field fldFrequency("",8,13,WHITE);
Field fldMode("",29,13,WHITE);
Field lblCTCSS("",47,12,mainfields);
Field fldCTCSS("",47,13,WHITE);
Field lblHz("Hz",53,13,DARKGRAY);
Field fldSpeaker("",65,13,WHITE);

// Second Row Fields
Field fldSignal("",11, 16, WHITE);
Field fldVol("",26, 16, WHITE);
Field fldSql("",37, 16, WHITE);
Field fldLR("",30, 16, WHITE);
Field lblDCS("",48,15,mainfields);
Field fldDCS("",48, 16, WHITE);
Field fldModulation("", 65,16,WHITE);


// Third Row Fields
Field fldSquelch("",11, 19, WHITE);
Field fldTape_control("",32,19,WHITE);
Field lblLTR("AREA GOTO HOME  ID   FREE",48,19,WHITE);
Field fldArea("",50,20, WHITE);
Field fldGoto("",54,20, WHITE);
Field fldHome("",59,20, WHITE);
Field fldId("",64,20, WHITE);
Field fldFree("",70,20, WHITE);

// DTMF Field
Field fldDTMF("",9,22,WHITE);

// Footer fields
Field fldEmulation("",15,24,WHITE);
Field fldStoreScan("",43,24,WHITE);

#include "c:\csource\optocom\21\audio.cpp"
#include "c:\csource\optocom\21\commloop.cpp"
#include "c:\csource\optocom\21\common.cpp"
#include "c:\csource\optocom\21\keyboard.cpp"
#include "c:\csource\optocom\21\modes.cpp"
#include "c:\csource\optocom\21\odfe.cpp"
#include "c:\csource\optocom\21\sendcmd.cpp"
#include "c:\csource\optocom\21\sfp.cpp"
#include "c:\csource\optocom\21\tape.cpp"
#include "c:\csource\optocom\21\timeout.cpp"
#include "c:\csource\optocom\21\tones.cpp"
