// Updated on 9-14-99
// added attempts


// CI-5 Command Layer 
// 
// FILENAME audio.cpp
// ENABLE SPEAKER AUDIO
// 10-7-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Enable_speaker_audio(void)
{
	
    // Local variables
	int attempts = 0;

start:

	// Load command buffer
	command[0] = 0xFE;
	command[1] = 0xFE;
	command[2] = address;  // global
	command[3] = 0xE0;
	command[4] = 0x7F;
	command[5] = 0x0A;
	command[6] = 0xFD;
	command[7] = 0xFF;

	// Set expected response length
	// See spec manual
	expected = 4;
	
	// Command is now ready to send, so send it
	Send_command();
 		 
	// Check to see if timeout occurred
	if (count >= TIMEOUT_VALUE)
	{
	    return TIMEOUT;
	}

	// Make sure the response is good

	if (response[2] == 0xFB)
	{
	    return GOOD;
	}

	if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}

// If we get here, something is really wrong.
return FATAL_ERROR; 
}




// CI-5 Command Layer 
// 
// FILENAME audio.cpp
// DISABLE SPEAKER AUDIO
// 10-7-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Disable_speaker_audio(void)
{
	
	// Local variables
	int attempts = 0;

start:
	// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x0B;
	 command[6] = 0xFD;
     command[7] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 4;

	 // Command is now ready to send, so send it
	 Send_command();
 		 
	// Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	 // Make sure the response is good
	  
	 if (response[2] == 0xFB)
	 {
		 return GOOD;
	 }

	if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}

// If we get here, something is really wrong.
return FATAL_ERROR; 
}


// CI-5 Command Layer 
// 
// FILENAME audio.cpp
// READ VOLUME SETTING
// 10-8-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Read_volume_setting(void)
{

	// Local Variables
	int attempts =0;

start:
	// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x14;
	 command[6] = 0xFD;
     command[7] = 0xFF;
     
	 // Set expected response length
	 // See spec manual
	 expected = 6;

	 // Command is now ready to send, so send it
	 Send_command();
	 
	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}

	
	 // Parse Response
    
	 // Left nibble of 4th byte is 10's
     volume_setting[0] = (response[4] >> 4) + 0x30;
	 // Right nibble of 4th byte is 1's
	 volume_setting[1] = (response[4] & 0x0F) + 0x30;
     // Add NULL to end
	 volume_setting[2] = NULL;

	 // Make sure response is valid
	 if ((volume_setting[0] < 0x30) || (volume_setting[0] > 0x39))
	 {
		 // Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	 }
	
	 if ((volume_setting[1] < 0x30) || (volume_setting[1] > 0x39))
	 {
		 // Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	 }

return SUCCESS;
}

// CI-5 Command Layer 
// 
// FILENAME audio.cpp
// READ SQUELCH SETTING
// 10-8-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Read_squelch_setting(void)
{

	// Local Variables
	int attempts = 0;

start:

	// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x16;
	 command[6] = 0xFD;
     command[7] = 0xFF;

	 // Set expected response length
	 // See spec manual
	  expected = 6;
	 
	 // Command is now ready to send, so send it
	 Send_command();
	 
	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}

	
	 // Parse Response
	 
	 // Left nibble of 4th byte is 10's
     squelch_setting[0] = (response[4] >> 4) + 0x30;
	 // Right nibble of 4th byte is 1's
	 squelch_setting[1] = (response[4] & 0x0F) + 0x30;
     // Add NULL to end
	 squelch_setting[2] = NULL;

	  // Make sure response is valid
	 if ((squelch_setting[0] < 0x30) || (squelch_setting[0] > 0x39))
	 {
		 // Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	 }
	
	 if ((squelch_setting[1] < 0x30) || (squelch_setting[1] > 0x39))
	 {
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	 }

return SUCCESS;
}

// CI-5 Command Layer 
// FILENAME audio.cpp
// WRITE VOLUME SETTING
// 10-8-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98


int Write_volume(int value)
{

	// Local variables
	
	int attempts =0;
	int hundreds;
	int tens;
	int ones;
	int remainder;
    int byte;
    int result;

	// Test incoming value to be sure it's between 0 and 99

	if ( (value < 0) || (value > 99) )

	{
		return FATAL_ERROR;
	}


	// Convert value to hex byte

     tens = value / 10;
	 ones = value % 10;


	// Prepare tens 

	 tens = (tens << 4);
	 tens = (tens & 0xF0);

	// Prepare ones

	 ones = (ones & 0x0F);

	// Create hex byte

	 byte = (tens | ones);

start:

// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x15;
	 command[6] = byte;
	 command[7] = 0xFD;
	 command[8] = 0xFF;


// Command is now ready to send, so send it

	 // Command is now ready to send, so send it

	 // Set expected response length
	 // See spec manual
	 expected = 4;

	 Send_command();

	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }


	 if (response[2] == 0xFB)
	 {
		 return GOOD;
	 }

	if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}

// If we get here, something is really wrong.
return FATAL_ERROR; 

}
	 

// CI-5 Command Layer 
// FILENAME audio.cpp
// WRITE SQUELCH SETTING
// 10-8-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Write_squelch(int value)
{

	// Local variables

	int attempts=0;
	int hundreds;
	int tens;
	int ones;
	int remainder;
    int byte;
    int result;

	// Test incoming value to be sure it's between 0 and 99

	if ( (value < 0) || (value > 99) )

	{
		return FATAL_ERROR;
	}


	// Convert value to two hex bytes

     tens = value / 10;
	 ones = value % 10;

    // Prepare tens 

	 tens = (tens << 4);
	 tens = (tens & 0xF0);

	// Prepare ones

	 ones = (ones & 0x0F);

	// Create hex byte

	 byte = (tens | ones);

start:
    // Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x17;
	 command[6] = byte;
	 command[7] = 0xFD;
     command[8] = 0xFF;

     // Set expected response length
	 // See spec manual
	 expected = 4;

	 // Command is now ready to send, so send it
    
	 Send_command();

	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }



	 if (response[2] == 0xFB)
	 {
		 return GOOD;
	 }

	if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}


return FATAL_ERROR; // If we get here, something is really wrong.


}


// CI-5 Command Layer
// FILENAME audio.cpp
// ENABLE REMOTE VOLUME/SQUELCH
// 10-8-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Enable_remote_volume_squelch(void)
{
	
	// Local variables
	int attempts = 0;

start:
    // Load the command buffer

	command[0] = 0xFE;
	command[1] = 0xFE;
	command[2] = address;  // global
	command[3] = 0xE0;
	command[4] = 0x7F;
	command[5] = 0x13;
    command[6] = 0x01; // Enable remote mode
	command[7] = 0xFD;
    command[8] = 0xFF;

    // Set expected response length
	 // See spec manual
	 expected = 4;

	// Command is now ready to send, so send it
    
	Send_command();

	// Check to see if timeout occurred
	if (count >= TIMEOUT_VALUE)
	{
	    return TIMEOUT;
	}

	 if (response[2] == 0xFB)
	 {
		 return GOOD;
	 }

	if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}


return FATAL_ERROR; // If we get here, something is really wrong.


}


// CI-5 Command Layer 
// FILENAME audio.cpp
// ENABLE LOCAL VOLUME/SQUELCH
// 10-8-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Enable_local_volume_squelch(void)
{

	// Local variables
	int attempts = 0;

start:
     // Load the command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x13;
     command[6] = 0x00; // Enable local mode
	 command[7] = 0xFD;
     command[8] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 4;


	 // Command is now ready to send, so send it
    
	 Send_command();

	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }


	 if (response[2] == 0xFB)
	 {
		 return GOOD;
	 }

	if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}


return FATAL_ERROR; // If we get here, something is really wrong.


}