// Communications loop
// Called by various other functions
// FILENAME commloop.cpp
// 9-22-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int comm_loop(void)

{
    // Local variables

	int result;  
	
	// Initialize variables

	rxhp = 0;
	txhp = 0;
    txtp = 0;
    

    // start time out timer
	timer_start=clock();         


    for(;;)  // start loop
	{
		
		// Update spinner
		update_spinner();

		// update real time clock
		show_time();

 		// scan keyboard
		scan_kb();
	
	    send_byte();
	  
	    result = get_byte();
      
	  
	    // If get_byte comes back with SUCCESS, 
	    // it means that it was not an echo device, and
	    // has already determined that the correct response 
	    // is back, so the timeout section can be bypassed.
	    if (result == SUCCESS)
		{
		    return SUCCESS;
		} 

        result = comm_timer();

	    if (result == TIMEOUT) //  did it timeout ?

		{
			return TIMEOUT;
		} 

	}   // end loop

}

// Send Byte
// FILENAME commloop.cpp
//
// 10-5-98
// Optoelectronics Inc.
// All Rights Reserved
//
// Finished for OptoCom on 11-11-98

/*************************************************************************/
/*                   send_byte() function                                */
/*                                                                       */
/* This function checks to see if there is a byte in the command buffer  */
/* to be sent, and sends it if the TX buffer is empty.                   */
/* If the command buffer is empty, or the TX buffer is not empty, it     */
/* returns without doing anything.                                       */
/*                                                                       */
/*  INPUTS: NONE                                                         */
/*  OUPUTS: NONE                                                         */
/*  CALLS : inportb(), outportb(),                                       */
/*                                                                       */
/*************************************************************************/

void send_byte(void)
{
	// The following is true if the tx buffer is empty
    if  (inportb(base + LINE_STATUS) & 0x20)  
    {
		// Make sure we are not at the end of the command buffer
        if (command[txtp] != 0xFF) 
		{
			// Send current byte
			outportb(base, command[txtp]);
			// Point to next byte
			txtp++;
		}

	}

	// All done, so go back
	return;
}

// Get Byte
// FILENAME commloop.cpp
//
// 10-5-98
// Optoelectronics Inc.
// All Rights Reserved
//
// Finished for OptoCom on 11-11-98


int get_byte(void)
{

   // Check for byte in buffer 
   if (inportb(base + LINE_STATUS) & 0x01)  
    {
      // Store byte in response buffer 
	  response[rxhp] = inportb(base); 
      // Point to next location in buffer 
	  rxhp++;                       

    }

   // Check for FE. If FE comes in, clear the rxhp.

    if (response[(rxhp - 1)] == 0xFE)
	{
		rxhp = 0;
	}
	

    // Check to see if it was an FD

	if (response[(rxhp - 1)] == 0xFD)

	 {
	
		// Check for complete response
		
		// 1. FD came in, and E0 is in first location (not the echo)
		

		if (response[0] == 0xE0)
		{

			// Test length of response against
			// expected length
			 if (expected == rxhp)
			 {
			     return SUCCESS;
			 }
			 else // make sure it isn't just a bad response
			 {

				 // If expected is 4, and
			     // we get less back, we
			     // must allow it to timeout
			     // because it won't parse right
			     if (expected != 4)
			     {
				      if (response[rxhp-2] == 0xFA)
			        {
					    	return SUCCESS;
			        }
			      }
			  }


			//return SUCCESS; // remove this line when done
		}

	
		
     } 

	return 0; // keep on going....
}

// Communications timer routine
// FILENAME commloop.cpp
// 9-22-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int comm_timer(void)
{

  // Stop the timer
  timer_stop = clock();

  // Has .2 seconds elapsed?
  // If so, return timeout.
  if (((timer_stop - timer_start) / CLK_TCK) > .2)

  { 
   return TIMEOUT;
  }

// If .1 second has not elasped, just return a zero to say all is well, keep trying.

  return 0; 

  
}

void update_spinner(void)
{
	   
		textcolor(LIGHTRED);
	   // Update spinner
       if (spinner == 0)
	   {
		   spinner = 1;
		   gotoxy(3,24);
		   cprintf("\\");
		   goto common_exit;
	   }
       
       if (spinner == 1)
       {
		   spinner = 2;
		   gotoxy(3,24);
		   cprintf("|");
           goto common_exit;
       }
       if (spinner == 2)
	   {
		   spinner = 3;
		   gotoxy(3,24);
		   cprintf("/");
		   goto common_exit;
       }
       if (spinner == 3)
	   {
	       spinner = 0;
		   gotoxy(3,24);
		   cprintf("-");
		   goto common_exit;
	   }

common_exit:
textcolor(WHITE);
return;

}
