// Misc support functions 


//******************
//*  display_title *
//******************
//*
//* This function displays the title screen.
//*
//* INPUTS:   NONE
//* OUTPUTS:  NONE
//* CALLS:    window(), textbackground(), clrscr(), display_dialog(),
//*           textcolor(), gotoxy(), cprintf()


void display_title(void)
{

  // Select full screen window
  window(1, 1, 80, 25);                  
					                     
  // Select BLACK background          
  textbackground(BLACK);                 

  // Clear screen                     
  clrscr();                              

  // Display dialog box               
  display_dialog();                      

  // Select BLUE text
  textcolor(BLUE);                       

  // Select CYAN background           
  textbackground(CYAN);                  
	
  // Write title to screen
  gotoxy(9, 2);                          
  cprintf(" OPTOELECTRONICS, Inc. ");   

  // Select BLACK background          
  textcolor(BLACK);                      
					                     
  // Write remaining logo information to screen
  gotoxy(9, 4);                          
  cprintf("Optocom Control Software");    

  // 1.0 = original , 
  // 1.1 = no intermittent alert
  // 2.0 = new design with fixes learned in VB

  gotoxy(15, 6);
  cprintf("Version 2.1");                
	
  gotoxy(14, 8);                         
  cprintf("Copyright 1999");             
					                     
  gotoxy(11, 10);                        
  cprintf("All Rights Reserved.");       
					                     
  // Select WHITE text                					                     
  textcolor(WHITE);                      
	
  // Remove cursor                   
  _setcursortype(_NOCURSOR);             
  
  // Write "Press any key" message    
  gotoxy(2, 13);                         
  cprintf("Press any key to continue...");
					                     
  // Return                    
  return;                                
} 


//***************************
//* display_dialog function *
//***************************
//*                                                                        
//*	This function displays an empty dialog box.                            
//*                                                                        
//*	INPUTS:   NONE                                                         
//*	OUTPUTS:  NONE                                                         
//*	CALLS:    window(), textbackground(), clrscr()                         
//*                                                                         


void display_dialog(void)
{                        

  // Select dialog box shadow window  
  window(23, 8, 62, 20); 

  // Select BLUE background          
  textbackground(BLUE);                   

  // Clear screen                    
  clrscr();                               

  // Select dialog box window         
  window(21, 7, 60, 19);                  

  // Select CYAN background            
  textbackground(CYAN);               

  // Clear screen                     
  clrscr();                               
	
  // Return                           
  return;                                 
}


//************************
//* select_port function *
//************************
//*                                                                        
//*	This function prompts the operator to 
//* select the serial port to be     
//* used for communications with the receiver.                             
//*                                                                        
//* INPUTS:   NONE                                                         
//*	OUTPUTS:  base                                                         
//*	CALLS:    display_dialog(), textcolor(), textbackground(),             
//*           gotoxy(), cprintf(), initialize_port()                       


void select_port(void)
{
  // Declare local variables.
  char input_char;

  // Display dialog box. 
  display_dialog();

  // Select cyan text on black background. 
  textcolor(BLACK);
  textbackground(CYAN);

  // Write dialog title to screen.
  gotoxy(11, 2);
  cprintf(" SELECT SERIAL PORT ");

  // Select red background. 
  textbackground(CYAN);

  // Write remaining dialog information to screen.
  gotoxy(16, 5);
  cprintf("<1>  COM1");
  gotoxy(16, 6);
  cprintf("<2>  COM2");
  gotoxy(16, 7);
  cprintf("<3>  COM3");
  gotoxy(16, 8);
  cprintf("<4>  COM4");

  // Select white text.
  textcolor(WHITE);

  // Write "Enter Selection" message to screen.
  gotoxy(2, 13);
  cprintf("Enter Selection...");

  parse:

  // Parse keyboard inputs for menu selections.
  input_char = getch();
  switch (input_char)
  {
	// Select COM1.  
	case '1':					
		base = COM1;
		break;
	// Select COM2.  
	case '2':					
		base = COM2;
		break;
	// Select COM3.  
	case '3':					
		base = COM3;
		break;
	// Select COM4.
	case '4':					
		base = COM4;
		break;
	// Leave as is.
	case 0x0D:	
		break;
	// Try again.
	default:					
		goto parse;
  }

  // Initialize selected serial port.
  initialize_port();

  // Return.
  return;
}


//****************************
//* initialize_port function *
//****************************
//*
//*	This function initializes the currently
//* selected serial port based     
//* on the currently selected data rate.                                   
//*                                                                        
//* INPUTS:   base, rate                                                   
//*	OUTPUTS:  NONE                                                         
//*	CALLS:    outportb()                                                   

void initialize_port(void)
{
	// Local variable
	int junk;

  // Initialize line control register of selected serial port: 
  // 8 data bits, 1 stop bit, no parity, BREAK = off, DLAB = 1.
  outportb(base + LINE_CONTROL, 0x83);

  // Initialize data rate. 
  switch (rate)
  {
	// 9600 bps
	case R9600:												
		outportb(base + RECV_XMIT, 0x0C);
		outportb(base + INT_ENABLE, 0x00);
		break;
	// 4800 bps 
	case R4800:													
		outportb(base + RECV_XMIT, 0x18);
		outportb(base + INT_ENABLE, 0x00);
		break;
	// 2400 bps 
	case R2400:													
		outportb(base + RECV_XMIT, 0x30);
		outportb(base + INT_ENABLE, 0x00);
		break;
    // 1200 bps
	case R1200:													
		outportb(base + RECV_XMIT, 0x60);
		outportb(base + INT_ENABLE, 0x00);
		break;
	// 300 bps
	case R300:														
		outportb(base + RECV_XMIT, 0x80);
		outportb(base + INT_ENABLE, 0x01);
		break;
  }

  // Initialize line control register of selected serial port:
  // 8 data bits, 1 stop bit, no parity, BREAK = off, DLAB = 0.
  outportb(base + LINE_CONTROL, 0x03);

  // Initialize interrupt enable register of selected serial port:
  // disable all interrupts. 
  outportb(base + INT_ENABLE, 0x00);

  // Initialize modem control register of selected serial port: 
  // negate RTS, DTR, and general purpose outputs, disable loopback test. 
  outportb(base + MODEM_CONTROL, 0x00);

  // Clear port by loading a byte(if one is present) into junk variable 
  // Check for byte in buffer  
  if (inportb(base + LINE_STATUS) & 0x01)  
    {
      // throw byte away 
	  junk = inportb(base); 
    }
  // Return.
  return;
}

// End Misc. Support functions






// BORDER FUNCTION
// This function draws the border around the screen, and the
// header and footer areas.


void border(void)
{
	// Local variables and constants
	const int vert = 186;
    const int horiz = 205;
    const int top_left = 201;
    const int top_right = 187;
    const int bot_left = 200;
    const int bot_right = 188;
    const int left_tee = 185;
    const int right_tee = 204;
    const int down_tee = 203;
    const int up_tee = 202;
    int t;

	// Set border color
	textcolor(bordercolor);
	
// X is horizontal, Y is vertical  
    
	// Draw top and bottom horizonal lines
	for (t = 2; t <= 78; t++)
    {
         gotoxy(t,1);
         cprintf("%c", horiz);
         gotoxy(t,25);
         cprintf("%c", horiz);
    }

	// Draw left and right vertical lines
    for (t = 2; t <= 24; t++)
    {
         gotoxy(1,t);
         cprintf("%c", vert);
         gotoxy(79,t);
         cprintf("%c", vert);
    }

    // Draw four corners of screen
    gotoxy(1,1);
    cprintf("%c", top_left);

    gotoxy(1,25);
    cprintf("%c", bot_left);

    gotoxy(79,1);
    cprintf("%c", top_right);

    gotoxy(79,25);
    cprintf("%c", bot_right);

    // Draw left tee at bottom for footer frame
    gotoxy(1,21);
    cprintf("%c", right_tee);

    // Draw right tee at bottom for footer frame
    gotoxy(79,21);
    cprintf("%c", left_tee);

	// Draw left tee at bottom for footer frame
    gotoxy(1,23);
    cprintf("%c", right_tee);

    // Draw right tee at bottom for footer frame
    gotoxy(79,23);
    cprintf("%c", left_tee);


    // Draw top of dtmf frame
    for (t = 2; t <= 78; t++)
    {
         gotoxy(t,21);
         cprintf("%c", horiz);
    }

	// Draw bottom of dtmf frame
    for (t = 2; t <= 78; t++)
    {
         gotoxy(t,23);
         cprintf("%c", horiz);
    }


    // Draw left tee at top for header frame
    gotoxy(1,3);
    cprintf("%c", right_tee);

    // Draw right tee at top for header frame
    gotoxy(79,3);
    cprintf("%c", left_tee);

    // Draw horizontal part of header frame.
    for (t = 2; t <= 78; t++)
    {
	 gotoxy(t,3);
	 cprintf("%c", horiz);
    }

    // Draw down tee's on header frame.
   gotoxy(20, 1);
   cprintf("%c", down_tee);
   gotoxy(46, 1);
   cprintf("%c", down_tee);

   // Draw up tee's on header frame.
   gotoxy(20, 3);
   cprintf("%c", up_tee);
   gotoxy(46, 3);
   cprintf("%c", up_tee);

   // Draw vertical part of header frame, left and right side.
   gotoxy(20, 2);
   cprintf("%c", vert);
/*   gotoxy( (COL1 - 2), 3);
   cprintf("%c", vert);*/
   gotoxy(46, 2);
   cprintf("%c", vert);
/*   gotoxy( (COL2 + 15), 3);
   cprintf("%c", vert);
  */

   // Draw upper horizontal bar
    for (t = 2; t <= 78; t++)
	{
         gotoxy(t,10);
         cprintf("%c", horiz);
    }

	// Draw tees for upper horizontal bar
	gotoxy(1,10);
	cprintf("%c", right_tee);
	gotoxy(79,10);
	cprintf("%c", left_tee);

   // Header Messages
    textcolor(WHITE);
    gotoxy(5,2);
    cprintf("Version  2.1");

/*   // Footer Messages
   textcolor(YELLOW);

   gotoxy(5, 24);
   cprintf("Visit Optoelectronics Online at http://www.optoelectronics.com/");
   
   gotoxy(5, 24);
   


   textcolor(WHITE);
*/
   return;
}


// EXTRACT_VERSIONS
// 
// Extracts the version information from the Optocom
//
// Finished for OptoCom on 11-11-98

void Extract_versions(void)
{
	// Local Variables

	unsigned char tens;
	unsigned char ones;


    // Extract Software Version


	// Shift right 4 to move the left side over to the right
	tens = response[7] >> 4;
	// Mask the left side to all zeros
	tens = tens & 0x0F;

	// Convert to ASCII
    tens = tens + 0x30;

    // Mask left side to leave the right
	ones = response[7] & 0x0F;
	
	// Convert to ASCII
    ones = ones + 0x30;

	// Construct the global sv variable
		   
	sv[0] = tens;
	sv[1] = '.';
	sv[2] = ones;
	sv[3] = NULL;

	// Extract Interface Version


    // Shift right 4 to move the left side over to the right
	    tens = response[8] >> 4;
	    // Mask the left side to all zeros
	    tens = tens & 0x0F;

	    // Convert to ASCII
        tens = tens + 0x30;

	    // Mask left side to leave the right
	    ones = response[8] & 0x0F;
	
	    // Convert to ASCII
        ones = ones + 0x30;

	    // Construct the global iv variable
		   
	    iv[0] = tens;
	    iv[1] =  '.';
	    iv[2] = ones;
	    iv[3] = NULL;

}	


// Initialize function
// Gets com port and sets up main screen

void Initialize (void)
{
  // Select serial port. 
  select_port();

  // Initialize port. 
  initialize_port();

  // Display window 
  window(1, 1, 80, 25);

  // Select black background. 
  textbackground(BLACK);

  // Clear screen. 
  clrscr();

  // Set text color 
  textcolor(YELLOW);

  // Show border
  border();
  
  // Set text color to White
  textcolor(WHITE);

  // Display Title
  gotoxy(22,2);
  cprintf("Optocom Control Program");
  gotoxy(50,2);
  cprintf("Optoelectronics, Inc. 1999");
}

// Clock function
// Displays real time clock when called
//
// Finished for OptoCom on 11-11-98

void show_time(void)
{
	 // Local variables

	 time_t lt;       // holds time value
	 lt = time(NULL); // get time value
	 char now[27];    // entire time value
	 char t[9];       // wanted portion of time value

	 // Convert time using ctime() function,
	 // and copy entire string into 'now'
     strcpy(now,ctime(&lt));
     
	 // Extract wanted portion into 't'
	 t[0] = now[11];
     t[1] = now[12];
     t[2] = now[13];
     t[3] = now[14];
     t[4] = now[15];
     t[5] = now[16];
     t[6] = now[17];
     t[7] = now[18];
     t[8] = NULL;

	 // Display the time in lower right corner
	 gotoxy(70,24);
	 cprintf("%s", t);

}

// CI-5 Command Layer
// FILENAME: writefrq.cpp
// Write Frequency
//
// 10-5-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for Optocom on 11-6-98

int Write_frequency(long freq)
{

	// Local Variables
    int hz;
	int ten_hz;
	int hundred_hz;
	int khz;
	long ten_khz;
	long hundred_khz;
	long mhz;
	long ten_mhz;
	long hundred_mhz;
	long ghz;
    long remainder;
	int result;
	int attempts = 0;


	// Validate incoming frequency

	// Note: This check is to make this
	// function reusable. In this program,
	// it should never return a fatal error,
	// since the frequency is checked before
	// it is sent to this function
	// If you use this function elsewhere, be
	// sure to either handle the fatal error 
	// condition that this function can return,
	// or be certain to check your frequency
	// before sending it into this function.
	// It would be best to have both checks in
	// place, but I chose not to write the code
	// that would handle the fatal error. 


		// 25-520, 760-823.995, 849-868.995, 894-1300

		if (freq < 25000000) 
		{
			return FATAL_ERROR;
		}

		if ((freq > 520000000) && ( freq < 760000000))
		{
			return FATAL_ERROR;
		}

		if ((freq > 823995000) && (freq < 849000000))
		{
			return FATAL_ERROR;
		}

		if ((freq > 868995000) && (freq < 894000000))
		{
			return FATAL_ERROR;
		}

		if (freq > 1300000000)
		{
			return FATAL_ERROR;
		}
	
        // Check for even multiple of 5khz or 12.5khz

		if ((freq % 5000) != 0) // if not evenly 
		{                       // divisible by 5000

			if ((freq % 12500) != 0) // if not evenly 
			{                        // divisible by 12500
				return FATAL_ERROR;
			}
		}


		
	    // Convert from long to hex format for transmission

        ghz =       freq / 1000000000;
	    remainder = freq % 1000000000;

	    hundred_mhz = remainder / 100000000;
	    remainder =        freq % 100000000;
     
	    ten_mhz = remainder / 10000000;
	    remainder =    freq % 10000000;

	    mhz =  remainder / 1000000;
        remainder = freq % 1000000;

	    hundred_khz = remainder / 100000;
	    remainder =        freq % 100000;

	    ten_khz = remainder / 10000;
	    remainder =    freq % 10000;

        khz =  remainder / 1000;
	    remainder = freq % 1000;

        hundred_hz = remainder / 100;
	    remainder =       freq % 100;

	    ten_hz = remainder / 10;
	    hz =          freq % 10;

	    // Shift appropriate bytes left and mask

	    ghz = ghz << 4;
	    ghz = ghz & 0xF0;

	    ten_mhz = ten_mhz << 4;
	    ten_mhz = ten_mhz & 0xF0;

	    hundred_khz = hundred_khz << 4;
	    hundred_khz = hundred_khz & 0xF0;

	    khz = khz << 4;
	    khz = khz & 0xF0;

	    ten_hz = ten_hz << 4;
	    ten_hz = ten_hz & 0xF0;

start:	 
	    // Prepare ten hz and one hz

	    command[5] = (ten_hz | hz);

 	    // Prepare 1khz, 100hz

	    command[6] = (khz | hundred_hz);

	    // Prepare 100khz, 10khz

	    command[7] = (hundred_khz | ten_khz);

	    // Prepare 10mhz, 1 mhz

	    command[8] = (ten_mhz | mhz);

	    // Prepare 1ghz, 100mhz

	    command[9] = (ghz | hundred_mhz);

	    // Fill in the rest of the command

	    command[0] = 0xFE;
	    command[1] = 0xFE;
	    command[2] = address; // global
	    command[3] = 0xE0;
	    command[4] = 0x05;
        command[10] = 0xFD;
	    command[11] = 0xFF;

	   // Set expected response length
       // See spec manual
	   expected = 4;


        // Command is now ready to send, so send it
 
        Send_command();
      
        // Check to see if timeout occurred
	    if (count >= TIMEOUT_VALUE)
		{
		    return TIMEOUT;
		}

	    // See if response is valid

		if (response[2] == 0xFB)
		{
		    return GOOD;
		}

	if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}
	
	// If we are here, something is really wrong.
		return FATAL_ERROR; 
}

// CI-5 Layer
// READ STATUS
// FILENAME: readstat.cpp
//
// Optoelectronics Inc.
// 10-16-98
// All Rights Reserved
//
// Finished for OptoCom on 11-11-98

int Read_status(void)
{

	// Local Variables

	int nrz_mode0 = 0;
	int nrz_mode1 = 0;
	int nrz_mode2 = 0;
	int attempts = 0;

start:
	// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x05;
	 command[6] = 0xFD;
     command[7] = 0xFF;

	 // Set expected response length
	 // See spec manual
if (device == OPTOCOM)
{
	expected = 9;
}
if (device == OPTOSCAN)
{
	expected = 8;
}

	 // Command is now ready to send, so send it

	 Send_command();
	 
	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	 //Check for error response
	 if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}

	 // Mask with appropriate hex value to isolate
	 // desired value

	 //   0    0     0     0    0     0     0     0

	 // 128   64    32    16    8     4     2     1 
	 // 0x80  0x40  0x20  0x10  0x08  0x04  0x02  0x01
     
	 
	 // 0x01 = 00000001
	 // 0x02 = 00000010
	 // 0x04 = 00000100
	 // 0x08 = 00001000
	 // 0x10 = 00010000
	 // 0x20 = 00100000
	 // 0x40 = 01000000
	 // 0x80 = 10000000
	 
	 if (device == OPTOCOM)
	 {
		 // for this application, S1 is position 4, S2 is 5, S3 is 6,
		 // and S4 is 7

		  volume_squelch_control_status = response[4] & 0x01;

		  dtmf_pending = response[4] & 0x02; 
	 	 
		  dtmf_overrun = response[4] & 0x04;

		  squelch_status = response[4] & 0x10;
	  		 
		  ctcss_active = response[4] & 0x20;

		  nrz_active = response[4] & 0x40;

		  tape_control = response[5] & 0x01;
		  
		  speaker_control = response[5] & 0x02;

		  search_window = response[5] & 0x04;

		  audio_status = response[5] & 0x10;

		  search_mode = response[5] & 0x20;

		  scan_mode = response[5] & 0x40;

		  frequency_received = response[6] & 0x01;
		  
		  mode_received = response[6] & 0x02;

		  pipeline_received = response[6] & 0x04;

		  nrz_mode0 = response[7] & 0x01;

		  nrz_mode1 = response[7] & 0x02;

		  nrz_mode2 = response[7] & 0x04;

		  if ( (nrz_mode0 == 0) && (nrz_mode1 == 0) && (nrz_mode2 == 0) )
		  {
			  nrz_mode = DCS;
		  }

		  if ( (nrz_mode0 == 1) && (nrz_mode1 == 0) && (nrz_mode2 == 0) )
		  {
			  nrz_mode = LTR;
		  }

	 }	  


if (device == OPTOSCAN)
{
       dtmf_pending = response[4] & 0x02;
       dtmf_overrun = response[4] & 0x04;
       squelch_status = response[4] & 0x10;
       ctcss_active = response[4] & 0x20;
       nrz_active = response[4] & 0x40;
       tape_control = response[5] & 0x01;
       speaker_control = response[5] & 0x02;
       search_window = response[5] & 0x04;
       audio_status = response[5] & 0x10;
}


return 0;
}

// CI-5 Command Layer 
// 
// FILENAME readsig.cpp
// READ SIGNAL STRENGTH
// 10-7-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Read_signal_strength(void)
{

	// Local variables
	int attempts = 0;

start:
	// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x15;
	 command[5] = 0x02;
	 command[6] = 0xFD;
     command[7] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 7;

	 // Command is now ready to send, so send it

	 Send_command();
	 
	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}
	
	 // Right nibble of 4th byte will be 0 or 1
     signal[0] = (response[4] & 0x0F) + 0x30;
	 // Left nibble of 5th byte
     signal[1] = (response[5] >> 4) + 0x30;
	 // Right nibble of 5th byte
	 signal[2] = (response[5] & 0x0F) + 0x30;
     // Add NULL to end
	 signal[3] = NULL;

	 if ((signal[0] < 0x30) || (signal[0] > 0x31))
	 {
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}
		goto start;
	 }
	 
	 if ((signal[1] < 0x30) || (signal[1] > 0x39))
	 {
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}
		goto start;
	 }

	 if ((signal[2] < 0x30) || (signal[2] > 0x39))
	 {
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}
		goto start;
	 }

	 // Trim leading zero if there is one

	 if (signal[0] == 0)
	 {
	     signal[0] = signal[1];
	     signal[1] = signal[2];
	     signal[2] = NULL;
	 }
	 
	 return SUCCESS;
}

// 6-14-99 Added extra validation and attempts...


// CI-5 Command Layer 
// For R11 Interceptor
// FILENAME readfreq.cpp
// READ FREQUENCY
// 9-30-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Read_frequency(void)
{

	// Local Variables

    int loop = 0;
    int pos = 0;
  	int result;
	int attempts = 0;
	int validate_attempts = 0;

start:
	// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x03;
	 command[5] = 0xFD;
     command[6] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 9;


	 // Command is now ready to send, so send it
    
	 Send_command();

	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}

	// Check for invalid response
	if (response[4] >0x99)
	{
		validate_attempts = validate_attempts + 1;
		if (validate_attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	if (response[5] >0x99)
	{
		validate_attempts = validate_attempts + 1;
		if (validate_attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	if (response[6] >0x99)
	{
		validate_attempts = validate_attempts + 1;
		if (validate_attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	if (response[7] >0x99)
	{
		validate_attempts = validate_attempts + 1;
		if (validate_attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	//Parse
	 for (loop = 7; loop >= 3; loop--)

	 {
          frequency[pos] = (response[(loop)] >> 4) + 0x30;
          frequency[pos + 1] = (response[(loop)] & 0x0F) + 0x30;
          pos = pos + 2;
	 }

	 // Convert to numeric version

	 n_frequency = atol(frequency);
                    
	 // Insert Decimal Point
	 for (loop = 9; loop >=4; loop--)
	 {
	      // Shift everyone over one to the right
		  frequency[loop + 1] = frequency[loop];
	 }
           
	 // Insert the decimal
	 frequency[4] = '.';
	   
	 // Make leading zero's spaces if necessary

	 if (frequency[0] == '0')
	 {
         frequency[0] = ' ';
         if (frequency[1] == '0')
		 {
		     frequency[1] = ' ';
		 }
	 }

	 // Add MHz to end
	
	 frequency[9] = ' ';
	 frequency[10] = 'M';
	 frequency[11] = 'H';
	 frequency[12] = 'z';
	 frequency[13] = NULL;

	 return SUCCESS;
	 
}

// CI-5 Command Layer 
// For all products
// FILENAME read_id.cpp
// READ ID
// 9-23-98
// Optoelectronics Inc.// All rights reserved
//
// Finished for OptoCom on 11-11-98

// NOTE: This function does nothing more
// than make sure the device is responding.
// Although it loads the response buffer
// with valid data, we are not parsing it
// here, because we already have valid
// data that was obtained from the get_id
// function while searching for the device
// in the beginning. Any calls to this 
// function should only be used for keeping
// a loop alive. That is, making sure we
// don't lose contact with a device while
// waiting for user input or something like
// that. Also, it is better to use the
// read_status function wherever it is available.
// This function is here for those devices 
// which do not support read_status

int read_id(void)
{

	// Local variables

	int result;

// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x09;
	 command[6] = 0xFD;
	 command[7] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 10;

// Command is now ready to send.


	 Send_command();
 
	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	 
// Extract ID code from response buffer



       id[0] = response[4];
       id[1] = response[5];
       id[2] = response[6];



   // If we have found the OptoCom, set the global
   // variable 'device' to OPTOCOM.

	   if ( (id[0] == 0x50) && (id[1] == 0x54) && (id[2] == 0x43) )
	   {
		   device = OPTOCOM;
	   }
	   if ( (id[0] == 0x35) && (id[1] == 0x33) && (id[2] == 0x35) )
	   {
		   device = OPTOSCAN;
	   }


	 return SUCCESS;
}


// CI-5 Command Layer 
// Used only by Search for product function
// FILENAME read_id.cpp
// GET ID
// 10-16-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

// NOTE: Must be this way because we cannot use Send_command()
// when searching for a product, since there is never a SUCCESS
// followed by a TIMEOUT, to reset the count in timeout();


int get_id(void)
{

	// Local variables

	int result;
	unsigned char tens;
	unsigned char ones;
		

// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x09;
	 command[6] = 0xFD;
	 command[7] = 0xFF;

// Set expected response length
	 // See spec manual
	 expected = 10;


// Command is now ready to send.


	 
  result = comm_loop();

   if (result == TIMEOUT)
   {
	   return TIMEOUT;
   }
   		
        // Test to see which product it is
        // With a valid Read ID response, the first byte should
		// always be at 4, and the last should always be at 6.
		// We must check to see
		// which address worked so we will know how to extract the
		// ID code, and other version info. Some products have more
		// version info than others.
		


// Extract ID code from response buffer



       id[0] = response[4];
       id[1] = response[5];
       id[2] = response[6];



   // If we have found the OptoCom, set the global
   // variable 'device' to OPTOCOM.

	   if ( (id[0] == 0x50) && (id[1] == 0x54) && (id[2] == 0x43) )
	   {
		   device = OPTOCOM;
	   }
	   if ( (id[0] == 0x35) && (id[1] == 0x33) && (id[2] == 0x35) )
	   {
		   device = OPTOSCAN;
	   }


   return SUCCESS;


}

// Check Cellular Function
// This function checks to see if the unit is able
// to receive cellular frequencies, and sets a
// global flag to be used by other parts of the program

int Check_cellular(void)
{
	// Local Variables
	int result;
        
	// Send unit a cellular frequency to see how
	// it responds
	result = Write_frequency(870000000);
	if (result == TIMEOUT) 
	{
		return TIMEOUT;
	}
    
	if (result == BAD)
	{
		// Unit did not accept frequency
		cellular_capable = 0;
		return SUCCESS;
	}
     
	if (result == GOOD)
	{
		// Unit accepted frequency
		cellular_capable = 1;
		return SUCCESS;
	}
    
}

int Read_memory(int ml)
{
//Local variables
int attempts=0;
int tens=0;
int ones=0;
int byte=0;
int loop=0;
int pos=0;


//Dim leftside As String
//Dim rightside As String
//Dim whatsleft As Integer
//Dim length As Integer

// Convert incoming to hex byte
	// Convert value to two hex bytes

     tens = ml / 10;
	 ones = ml % 10;

    // Prepare tens 

	 tens = (tens << 4);
	 tens = (tens & 0xF0);

	// Prepare ones

	 ones = (ones & 0x0F);

	// Create hex byte

	 byte = (tens | ones);

start:

// Load command buffer
command[0] = 0xFE;
command[1] = 0xFE;
command[2] = address; // global
command[3] = 0xE0;
command[4] = 0x7F;
command[5] = 0x19;
command[6] = byte;
command[7] = 0xFD;
command[8] = 0xFF;

expected = 13;

// Send command
Send_command();

// Check to see if timeout occurred
if (count >= TIMEOUT_VALUE)
{
	return TIMEOUT;
}


// Check for error response
if (response[2] == 0xFA)
{   
    // Try up to 3 times per call
    attempts = attempts + 1;
    if (attempts > 3)
	{
        return BAD;
	}

    goto start;

}

// Parse response

//Parse
 for (loop = 8; loop >= 4; loop--)

 {
      frequency[pos] = (response[(loop)] >> 4) + 0x30;
      frequency[pos + 1] = (response[(loop)] & 0x0F) + 0x30;
      pos = pos + 2;
 }


	 // Convert to numeric version

	 n_frequency = atol(frequency);
                    
	 // Insert Decimal Point
	 for (loop = 9; loop >=4; loop--)
	 {
	      // Shift everyone over one to the right
		  frequency[loop + 1] = frequency[loop];
	 }
           
	 // Insert the decimal
	 frequency[4] = '.';
	   
	 // Make leading zero's spaces if necessary

	 if (frequency[0] == '0')
	 {
         frequency[0] = ' ';
         if (frequency[1] == '0')
		 {
		     frequency[1] = ' ';
		 }
	 }

	 // Add MHz to end
	
	 frequency[9] = ' ';
	 frequency[10] = 'M';
	 frequency[11] = 'H';
	 frequency[12] = 'z';
	 frequency[13] = NULL;
	 
	 
/*	 
//Extract Frequency
// ghz
optocom_frequency = Chr(Int((response[8] / 16)) + 0x30)
// hundred mhz
optocom_frequency = optocom_frequency + Chr((response[8] And 0xF) + &H30)
// ten mhz
optocom_frequency = optocom_frequency + Chr(Int((response_buffer(7) / 16)) + &H30)
' mhz
optocom_frequency = optocom_frequency + Chr((response_buffer(7) And &HF) + &H30)
' hundred khz
optocom_frequency = optocom_frequency + Chr(Int((response_buffer(6) / 16)) + &H30)
' ten khz
optocom_frequency = optocom_frequency + Chr((response_buffer(6) And &HF) + &H30)
' khz
optocom_frequency = optocom_frequency + Chr(Int((response_buffer(5) / 16)) + &H30)
' hundred hz
optocom_frequency = optocom_frequency + Chr((response_buffer(5) And &HF) + &H30)
' ten hz
optocom_frequency = optocom_frequency + Chr(Int((response_buffer(4) / 16)) + &H30)
' hz
optocom_frequency = optocom_frequency + Chr((response_buffer(4) And &HF) + &H30)

' Validate response

'If (Val(optocom_frequency) = 0) Then
'    Read_memory = ZERO
'    Exit Function
'End If

' Make sure it evaluates as a numeric
' If not, go back and try again.
If (IsNumeric(optocom_frequency) = False) Then
   GoTo start
End If

' Add decimal point
         
' Get length of whole string
length = Len(optocom_frequency)

' store right side of frequency (after where decimal will be)
rightside = Right(optocom_frequency, 6)
     
' Calculate remaining characters
' This will vary depending on frequency (mhz, or ghz)
whatsleft = length - Len(rightside)
     
' Extract left side using value just computed
leftside = Left(optocom_frequency, whatsleft)
     
' Eliminate leading zeroes
If (Left(leftside, 1) = "0") Then
   leftside = Mid(leftside, 2, Len(leftside))
End If
     
If (Left(leftside, 1) = "0") Then
   leftside = Mid(leftside, 2, Len(leftside))
End If

' Put the new string together, including decimal point
optocom_frequency = leftside + "." + rightside

  */

	 /*
' Extract Receive Mode
If (response_buffer(9) = &H5) Then
    current_memory_mode = "NFM"
End If

If (response_buffer(9) = &H6) Then
    current_memory_mode = "WFM"
End If

If (response_buffer(9) = &H2) Then
    current_memory_mode = "AM"
End If

' Extract Decode Mode
If (response_buffer(10) = &H0) Then
    current_memory_nrz_mode = DCS_MODE
End If
     
If (response_buffer(10) = &H1) Then
    current_memory_nrz_mode = LTR_MODE
End If

' Extract Operating Flags

current_memory_audio_status = response_buffer(11) And &H1
current_memory_search_mode = response_buffer(11) And &H2
current_memory_search_window = response_buffer(11) And &H4
current_memory_squelch_delay = response_buffer(11) And &H10
     
Read_memory = SUCCESS
*/
 return SUCCESS;
 }
