
// Comcounter Prgram
// Optoelectronics Inc.
// Started 6-16-99
//
// All Rights Reserved

#include "c:\csource\optocom\21\includes.h"





int main(void)
{
  // Local Variables
  int result = 0;
  int x;
  int y;
  char key;

  // Show the program title
  display_title();
  getch();

  // Get baud rate and set up main screen
  Initialize();

start:

  // Display message saying that we are looking for the OptoCom
  // This is being done here to keep the message from flickering
  // during the loop if the OptoCom is not found. The message
  // is displayed here once at the start of the search, then
  // cleared going into the odfe layer. Upon return from the 
  // odfe layer, the program flow returns to this point, 
  // thus displaying the message once again.

  // We also are initializing some globals here. They must
  // be initialized each time we begin looking for the OptoCom.
  // For information on what these are, and do, see includes.h

  // Clear global pos variable
  pos = 0;
  // Clear timeout counter
  count = 0;  
  // Clear previous flag to prevent false timeout alert
  previous = 0; 

  // Clear screen, except for border, before beginning

  clr_ol_fields();
  
  // Display message telling user that we are looking for device
  // Create Exit information fields
  
  Field lblExit1("CTRL-X",37,14,LIGHTGRAY);
  Field lblExit2("To Exit",37,15,LIGHTGRAY);
  
  
  gotoxy(24,12);
  cprintf("Unable to Communicate With Optocom");



  // Set up loop
  for (;;)
  {
	 

      // Call function to determine if the OptoCom
	  // is attached to the computer.
      // When called, this function will return SUCCESS
	  // if it finds the OptoCom, NORMAL_EXIT if the
	  // user hit control-x while it was looking, or
	  // TIMEOUT if the OptoCom was not found.

     result = search_for_product();

     // Now test the result
	 // If we got back a success code, it means
	 // that OPTOCOM is now stored in the 
	 // global device variable.
     if (result == SUCCESS)
	 {
		 // Make sure it found an Optocom
		 // For this program, that is the only possibility
		 if ((device == OPTOCOM)||(device == OPTOSCAN))
		 {
			 // If it is an Optocom,
			 // jump to the Optocom Direct Frequency Entry Layer
			 // This layer will return either NORMAL_EXIT, or
			 // TIMEOUT


			 result = Optocom_direct_frequency_entry();
			 
			 // Upon return from that Layer...

			 // Look for a normal exit request
		     if (result == NORMAL_EXIT)
			 {
				 // End the program
				 goto common_exit;
			 }

			 // Oops, something went wrong
			 if (result == FATAL_ERROR)
			 {
				 // Still not sure what to do here yet...
				 // But I've never seen a fatal error
				 // occur... if one does, it would mean
				 // I didn't do a good job of programming,
				 // so lets hope we never see one.

			 }

			 // If we are here, then it was a TIMEOUT,
			 // so start over

			 goto start;
		 
		 } // end of if (device == OPTOCOM)

	 } // end of if (result == SUCCESS)

     // Check to see if the user hit CTRL-X while it
	 // was looking for the OptoCom
     if (result == NORMAL_EXIT)
	 {
		 // End the program
		 goto common_exit;
	 }

	 // If we are here, it means no OptoCom was found, 
	 // and the user has not requested to exit,
	 // so we continue looping

  } // end of for(;;) loop


// This is where the exit cleanup occurs
// before we leave the program
common_exit:  


  // Restore full screen
  window(1, 1, 80, 25);

  // Restore text mode  
  textmode(LASTMODE);

  // Restore cursor
  _setcursortype(_NORMALCURSOR);

  // Restore screen colors
  textcolor(LIGHTGRAY);              
  textbackground(BLACK);             
				          
  // Clear screen
  clrscr();                         
  
  // return to operating system
  return 0;

} // end of main()

