// CI-5 Command Layer 
// 
// FILENAME readsig.cpp
// READ SIGNAL STRENGTH
// 10-7-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Read_signal_strength(void)
{

	// Local variables
	int attempts = 0;

start:
	// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x15;
	 command[5] = 0x02;
	 command[6] = 0xFD;
     command[7] = 0xFF;

	 // Command is now ready to send, so send it

	 Send_command();
	 
	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}
	
	 // Right nibble of 4th byte will be 0 or 1
     signal[0] = (response[4] & 0x0F) + 0x30;
	 // Left nibble of 5th byte
     signal[1] = (response[5] >> 4) + 0x30;
	 // Right nibble of 5th byte
	 signal[2] = (response[5] & 0x0F) + 0x30;
     // Add NULL to end
	 signal[3] = NULL;

	 if ((signal[0] < 0x30) || (signal[0] > 0x31))
	 {
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}
		goto start;
	 }
	 
	 if ((signal[1] < 0x30) || (signal[1] > 0x39))
	 {
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}
		goto start;
	 }

	 if ((signal[2] < 0x30) || (signal[2] > 0x39))
	 {
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}
		goto start;
	 }

	 // Trim leading zero if there is one

	 if (signal[0] == 0)
	 {
	     signal[0] = signal[1];
	     signal[1] = signal[2];
	     signal[2] = NULL;
	 }
	 
	 return SUCCESS;
}
