// CI-5 Command Layer 
// 
// FILENAME tones.cpp
// READ CTCSS
// 10-7-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-6-98

int Read_CTCSS(void)
{
	// Local variables
	int attempts = 0;

start:
	// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x06;
	 command[6] = 0xFD;
     command[7] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 7;


	 // Command is now ready to send, so send it

	 Send_command();
	 
	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	 if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}
	
	 // Parse Response
	 
	 // Left nibble of 4th byte
     ctcss[0] = (response[4] >> 4) + 0x30;
     // Right nibble of 4th byte will be 0 or 1
     ctcss[1] = (response[4] & 0x0F) + 0x30;
	 // Left nibble of 5th byte
     ctcss[2] = (response[5] >> 4) + 0x30;
	 // Decimal point
	 ctcss[3] = '.';
	 // Right nibble of 5th byte
	 ctcss[4] = (response[5] & 0x0F) + 0x30;
     // Add NULL to end
	 ctcss[5] = NULL;

	
	 // Validate response
	if ((ctcss[0] < 0x30) || (ctcss[0] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}
	
	if ((ctcss[1] < 0x30) || (ctcss[1] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}
	if ((ctcss[2] < 0x30) || (ctcss[2] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	 // Trim leading zero if there is one

	 if (ctcss[0] == 0)
	 {
		 ctcss[0] = ctcss[1];
		 ctcss[1] = ctcss[2];
		 ctcss[2] = ctcss[3];
		 ctcss[3] = ctcss[4];
		 ctcss[4] = NULL;
	 }

return SUCCESS;
}


// CI-5 Command Layer 
// 
// FILENAME tones.cpp
// READ DCS
// 10-7-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-6-98

int Read_DCS(void)
{
	// Local variables
	int attempts = 0;

start:
	// Load command buffer
	command[0] = 0xFE;
	command[1] = 0xFE;
	command[2] = address;  // global
	command[3] = 0xE0;
	command[4] = 0x7F;
	command[5] = 0x07;
	command[6] = 0xFD;
    command[7] = 0xFF;

	// Set expected response length
	 // See spec manual
	 expected = 7;

	// Command is now ready to send, so send it

	Send_command();
	 
	// Check to see if timeout occurred
	if (count >= TIMEOUT_VALUE)
	{
	    return TIMEOUT;
	}

	 if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}
	
	// Parse Response
	 
	// Right nibble of 4th byte
    dcs[0] = (response[4] & 0x0F) + 0x30;
	// Left nibble of 5th byte
    dcs[1] = (response[5] >> 4) + 0x30;
	// Right nibble of 5th byte
	dcs[2] = (response[5] & 0x0F) + 0x30;
    // Add NULL to end
	dcs[3] = NULL;

	if ((dcs[0] < 0x30) || (dcs[0] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	if ((dcs[1] < 0x30) || (dcs[1] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	if ((dcs[2] < 0x30) || (dcs[2] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}


    return SUCCESS;
}


// CI-5 Command Layer 
// 
// FILENAME tones.cpp
// READ DTMF DIGIT
// 10-7-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-6-98

int Read_DTMF_digit(void)
{
	// Local variables
	int attempts = 0;

start:
	// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x08;
	 command[6] = 0xFD;
     command[7] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 6;

	 // Command is now ready to send, so send it

	 Send_command();
	 
	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	 if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}
	
	 // Parse Response
	 
	 // First look for empty buffer

	 if (response[4] == 0x99)
	 {
		 return BUFFER_EMPTY;
	 }

	 // If the buffer isn't empty, get the digit

	 // Check for 0-9

	 if( (response[4] >= 0x00) && (response[4] <= 0x09) )
	 {
		 // Right nibble of 4th byte
         dtmf_digit = (response[4] & 0x0F) + 0x30;
	     return SUCCESS;
	 }

	 // Check for A,B,C,D
	 if ((response[4] >= 0x10) && (response[4] <= 0x13))
	 {
		 // Right nibble of 4th byte
         dtmf_digit = (response[4] & 0x0F) + 0x41;
	     return SUCCESS;
	 }

	 // Check for *
	 if (response[4] == 0x14)
	 {
		 dtmf_digit = '*';
		 return SUCCESS;
	 }

	 // Check for #
	 if (response[4] == 0x15)
	 {
		 dtmf_digit = '#';
		 return SUCCESS;
	 }

	 // If we get here, it means that we got
	 // garbage back, so try again up to 3 times
	 attempts = attempts + 1;
	 if (attempts > 3)
	 {
		return FATAL_ERROR;
	 }
	 goto start;

}


// CI-5 Command Layer 
// 
// FILENAME tones.cpp
// READ LTR DATA
// 10-7-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-6-98

int Read_LTR_data(void)
{

	// Local variables
	int attempts = 0;

start:
	// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x12;
	 command[6] = 0xFD;
     command[7] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 11;

	 // Command is now ready to send, so send it

	 Send_command();
	 
	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	 // Check for error response
	 if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}

	
	 // Parse Response
	 
     // Right nibble of 4th byte is AREA
     ltr_area[0] = (response[4] & 0x0F) + 0x30;
	 ltr_area[1] = NULL;
	 
	 // Left nibble of 5th byte is GOTO 10's place
     ltr_goto[0] = (response[5] >> 4) + 0x30;
	 // Right nibble of 5th byte is GOTO 1's place
	 ltr_goto[1] = (response[5] & 0x0F) + 0x30;
     // Add NULL to end
	 ltr_goto[2] = NULL;

	 // Left nibble of 6th byte is HOME 10's place
     ltr_home[0] = (response[6] >> 4) + 0x30;
	 // Right nibble of 6th byte is HOME 1's place
	 ltr_home[1] = (response[6] & 0x0F) + 0x30;
	 // Add NULL to end
	 ltr_home[2] = NULL;

	 // Right nibble of 7th byte is ID 100's place
	 ltr_id[0] = (response[7] & 0x0F) + 0x30;
	 // Left nibble of 8th byte is ID 10's place
     ltr_id[1] = (response[8] >> 4) + 0x30;
	 // Right nibble of 8th byte is ID 1's place
	 ltr_id[2] = (response[8] & 0x0F) + 0x30;
	 // Add NULL to end
	 ltr_id[3] = NULL;

	 // Left nibble of 9th byte is FREE 10's place
     ltr_free[0] = (response[9] >> 4) + 0x30;
	 // Right nibble of 9th byte is FREE 1's place
	 ltr_free[1] = (response[9] & 0x0F) + 0x30;
	 // Add NULL to end
	 ltr_free[2] = NULL;

	// Validate response

	if ((ltr_area[0] < 0x30) || (ltr_area[0] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	if ((ltr_goto[0] < 0x30) || (ltr_goto[0] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	if ((ltr_goto[1] < 0x30) || (ltr_goto[1] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	if ((ltr_home[0] < 0x30) || (ltr_home[0] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	if ((ltr_home[1] < 0x30) || (ltr_home[1] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	if ((ltr_id[0] < 0x30) || (ltr_id[0] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	if ((ltr_id[1] < 0x30) || (ltr_id[1] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	if ((ltr_id[2] < 0x30) || (ltr_id[2] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	if ((ltr_free[0] < 0x30) || (ltr_free[0] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

	if ((ltr_free[1] < 0x30) || (ltr_free[1] > 0x39))
	{
		attempts = attempts + 1;
		if (attempts > 3)
		{
			return BAD;
		}
		goto start;
	}

     return SUCCESS;
}

// DTMF buffer routine
// FILENAME dtmf.cpp
// Optoelectronics Inc. 1998
// All Rights Reserved
//
// Finished for Optocom on 11-19-98


void dtmf(void)
{

	// Local Variables
	int x;

	
	// If the buffer is full
	if(dtmf_buffer_pointer == 69)
	{
		// Shift array left by one

		for (x = 1; x <= 68; x++)
		{
			dtmf_buffer[x - 1] = dtmf_buffer [x];
		}

		// Put new character at end of array
		dtmf_buffer[68] = dtmf_digit;

		// Store time into last_dtmf_call variable
		last_dtmf_call = clock();

		// Done
		return;
	}

	// Put new character at current position in array
	dtmf_buffer[dtmf_buffer_pointer] = dtmf_digit;

	// Increment pointer
	dtmf_buffer_pointer++;

	// Store time into last_dtmf_call variable
	last_dtmf_call = clock();

	// Done
	return;
}

