
;	 If x80 bit in numcols then can send without underlines (no trail underline)
    ; if bit x40 then use single pixel time for columns with single pixel
    ; if bit 0x20 ,them send char single column timing (no repeat)

; ver 1.04
; 	 ? now shows MODE=
;    changed TCNT to upcount to TCNTms, mod at setim (check interletter 200mS time)
;	 have sei/cli at tdun:
;    idle mode at wtreset
;    new W
; ver 1.03 looks for cset2 at $1000
;          removed 5Hz frequency offset (1.021)
;		   !CSET=1 or 2				    (1.021)
;		   !TILT=+/- 1 or 2 for 5 or 10Hz (much improved over 1.021)
; only have one table for 100mS time. TILT=1 is for 2.5Hz
;
;
; ver 1.02 uses a different cset table to ver 1.01 and can draw either up or down in column.
;
;
; 50mS / 75mS ?
; portA
 ; b3 is output, (msb) b2,b1,b0 (lsb) are D/A output drive pins

; portB input select pins:
  ; b0 LSB is normally '1' for double up
  ; b1 is 1 for var time col, 0 for 100mS col
  ; b2 is fixed time/pixel 
  ; b3 is 0 for invert D/A
  ; b4 echo send character to serial/prog mode
  ; b7...b5 are outputs
;
; portC bit0 pulses high at start of character (for 'scope trigger)
  ; b1 might be for bootloader (input)
  ; b7...b2 and b0 are outputs, b4 toggles for each message
.equ TOGGLE= 4 ; after each message
;
; portD
; pD4,pD5 is output, square wave test tones, 1450Hz...1800Hz
; pD7 is 500Hz square wave or xtal/32*2*(249+1), this is from main 1mS interrupt.
;
.NOLIST
.include "mega16.def"
.LIST
; don't use macro after sbrc/sbrs! , need newer assembler for macros
.macro do_sndmsg
  ldi ZH,HIGH(slab<<1)
   ldi ZL,LOW(slab<<1)
   rjmp selab
slab:
	.db @0,0x80 ; notice additional 0x80 at end
selab:
     rcall sndmsl ; does not check length!! 
.endmacro

.macro ldx
	ldi XH,HIGH(@0)
	ldi XL,LOW(@0)
.endmacro

.macro ldy
	ldi yH,HIGH(@0)
	ldi yL,LOW(@0)
.endmacro

.macro ldz
	ldi zH,HIGH(@0)
	ldi zL,LOW(@0)
.endmacro
;
.macro pushy
	push YL
	push YH
.endmacro

.macro popy
	pop YH
	pop YL
.endmacro
;
; lpm r0 and mul r0,r1 not used
; r2 unused
.def zreg = r3
.def ffreg = r4
.def TTEMP = r5 ; EE preserve int flag

.def TCNT = R6 ; 1mS int
.def TCNTms = r7 ; 1mS int

.def tonH = r8 ; used for pD5
.def tonL = r9 ; used for pD5
.def TEMP2 = r10
.def colcnt = R11  ; number of columns to send
.def thiscol = r12
.equ b_drawup =7 ; bit of thiscol
.def rmv4 = R13 ; mod mv4
.equ b_notrail = 7 ; If x80 bit in numcols then can send without underlines (no trail underline)
.equ b_singpix = 6 ;    ; if bit x40 then use single pixel time for columns with single pixel
.equ b_norpt = 5    ; if bit 0x20 ,them send char single column timing (no repeat)

.def TILT=r14


.def ACCA = r16
.def ACCB = r17
.def TEMP1 = r18
.def PBCpy  = r19
           ; b0 LSB is normally '1' for double up
           ; b1 is double speed
           ; b2 is fixed time/pixel 
           ; b3 is 0 for invert D/A
           ; b4 echo send character to serial/prog mode
;
.def TXOPT = r20 ; index from $100, (send either msgbuff or tbuff)
.def PCNT= R21  ; this is 2 for lowest pixel in column, so 2...6 (1 is underline)
.def SERIAL = R22
.equ GOTLINE = 1 ; bit of SERIAL
.equ ECHOM =0    ; bit of SERIAL

.def STAT = r23
.equ b_tic1ms = 0  ; bit of STAT
.equ b_NXTCHR = 1  ; bit of STAT

.def COUNT1=r24
;r25 unused

;XL =R26	; 
;XH =R27
;YL =R28	; 
;YH =R29
;ZL =R30	; used by lpm
;ZH =R31
.dseg
	
.org $0070
EPAGE: .byte 1
QRS: .byte 1 ; '0'
csel: .byte 1 ;'1' for cset1, '2' for cset2
cbix: .byte 1 ; pointer into cbuf
chrix: .byte 1 ; pointer into msgbuff
lastchr: .byte 1
rxcnt: .byte 1
.org $0080
cbuf: .byte 16
tildebuf: .byte 8
;
.equ RBUFSIZ = 0x40 ; 64 char
.org $0100
msgbuff: .byte RBUFSIZ ; msg buff must be at x00
tbuff: .byte RBUFSIZ ; at 0x40
eebuff: .byte RBUFSIZ ; at x80
rxbuf:	.byte	RBUFSIZ ; rxbuff must be at xC0

.CSEG
.org $0000
	jmp begin	;1 reset 
; these vectors two words each!
	jmp wtreset	;int0
	jmp wtreset	;int1
	jmp tic1ms	;t2 compare
	jmp wtreset	;t2 o/f
	jmp wtreset	;t1 capt _rx
	jmp compA	; timer1 compare match A
	jmp wtreset	;  match b
	jmp wtreset	; t1 ov
	jmp wtreset	; t0 ov
	jmp wtreset	; SPI
	jmp Rxint	; serial
	jmp TXdre	; usart
	jmp wtreset	; TXC usart
	jmp wtreset	; adc
	jmp wtreset	; eeprom
	jmp wtreset	; comp
	jmp wtreset	; 2 wire
	jmp wtreset	; exint2
	jmp wtreset	; timer 0 compare
	jmp wtreset	; store prog ($28)
	
; 1mS int from Timer2   
tic1ms:  PUSH	ACCB
	IN	ACCB,SREG	 
	PUSH	ACCB
    cp TCNT,TCNTms
    brsh tic02
    inc TCNT
    tst zreg
    brne ticout
	wdr
    rjmp ticout
; this 1mS int isn't exact; so 50mS+50mS isn't exactly 100mS
tic02: sbr STAT,(1<<b_tic1ms)
	clr TCNT
    ; mov TCNT,TCNTms ; decrement TCNT, recharge from TCNTms
ticout:    POP	ACCB
	OUT	SREG,ACCB
	pop	ACCB
	RETI
;
; test tone int for pD5
compA:  PUSH	ACCB
	IN	ACCB,SREG	 
	pushy
    
    out OCR1AH,tonH
	out OCR1AL,tonL
; 90° 
; ----2222------\___________/-----------\___________ 2222+2222=4444 or 1800Hz
; --1111--\___________/-----------\___________
   
    mov yh,tonH
    mov yl,tonL
    lsr yh
    ror yl ;/2
    out OCR1BH,yh 
	out OCR1BL,yl
   
    ldi yl,(1<<OCIE2)   ; disable this int (1<<OCIE1A) 
    out TIMSK,yl
    popy
	OUT	SREG,ACCB
	pop	ACCB
	RETI

	
	.org $100
cset1:
; 32   
 .db  0x4,0x0,0x0,0x0,0x0,0x0
; 33  !
 .db  0x1,0xba,0x0,0x0,0x0,0x0
; 34  "
 .db  0x3,0xb8,0x80,0xb8,0x0,0x0
; 35  #
 .db  0x5,0x94,0xbe,0x94,0xbe,0x14
; 36  $
 .db  0x5,0x92,0xa9,0xbf,0xa5,0x92
; 37  %
 .db  0x5,0xb2,0xb4,0x88,0x96,0xa6
; 38  &
 .db  0x5,0x96,0xa9,0xad,0x12,0x5
; 39  '
 .db  0x5,0xbc,0x2b,0x21,0xaa,0x3c
; 40  (
 .db  0x2,0x94,0xa2,0x0,0x0,0x0
; 41  )
 .db  0x2,0xa2,0x94,0x0,0x0,0x0
; 42  *
 .db  0x5,0xa2,0x94,0xbe,0x94,0xa2
; 43  +
 .db  0x3,0x88,0x9c,0x88,0x0,0x0
; 44  ,
 .db  0x2,0x82,0x84,0x0,0x0,0x0
; 45  -
 .db  0x3,0x88,0x88,0x88,0x0,0x0
; 46  .
 .db  0x2,0x86,0x86,0x0,0x0,0x0
; 47  /
 .db  0x5,0x82,0x84,0x88,0x90,0x20
; 48  0
 .db  0x5,0x9c,0xa2,0xaa,0xa2,0x9c
; 49  1
 .db  0x1,0xbe,0x0,0x0,0x0,0x0
; 50  2
 .db  0x4,0xa6,0xaa,0xaa,0x9a,0x0 ;??//// 0x4,0xa6,0xaa,0xaa,0x9a,0x0
; 51  3
 .db  0x4,0xa2,0xaa,0xaa,0xbe,0x0
; 52  4
 .db  0x4,0x8C,0x94,0xa4,0xbe,0x80
; 53  5
 .db  0x4,0xba,0xaa,0xaa,0xac,0x0
; 54  6
 .db  0x4,0x9c,0xaa,0xaa,0xae,0x0
; 55  7
 .db  0x4,0xb0,0xa2,0xa4,0xb8,0x0
; 56  8
 .db  0x4,0xbe,0xaa,0xaa,0xbe,0x80
; 57  9
 .db  0x4,0xb2,0xaa,0xaa,0x9c,0x0
; 58  :
 .db  0x1,0x8a,0x0,0x0,0x0,0x0
; 59  ;
 .db  0x2,0x82,0x94,0x0,0x0,0x0
; 60  <
 .db  0x3,0x88,0x94,0xa2,0x0,0x0
; 61  =
 .db  0x3,0x94,0x94,0x94,0x0,0x0
; 62  >
 .db  0x3,0xa2,0x94,0x88,0x0,0x0
; 63  ?
 .db  0x4,0xb0,0xa0,0xaa,0x98,0x0
; 64  @
 .db  0x5,0x9e,0xa1,0xad,0xaa,0x9e ; 0x5,0x9e,0xa1,0xac,0xaa,0x9e
; 65  A
 .db  0x4,0x9e,0xa8,0xa8,0x1e,0x0
; 66  B
 .db  0x4,0x9e,0xaa,0xaa,0x96,0x0
 ; 67  C
 .db  0x4,0x9c,0xa2,0xa2,0xa2,0x0
; 68  D
 .db  0x4,0xa2,0xbe,0xa2,0x9e,0x0  ;0x4,0xa2,0xbe,0xa2,0x9c/9e,0x0
; 69  E
 .db  0x4,0xbe,0xaa,0xaa,0xaa,0x0
; 70  F
 .db  0x4,0xbe,0xa8,0xa8,0xa8,0x0
; 71  G
 .db  0x4,0x9c,0xa2,0xaa,0xae,0x0
; 72  H
 .db  0x4,0xbe,0x88,0x88,0xbe,0x0
; 73  I
 .db  0x3,0xa2,0xbe,0xa2,0x0,0x0
; 74  J
 .db  0x4,0xa4,0xa2,0xbe,0xa0,0x0
; 75  K
 .db  0x4,0xbe,0x88,0x94,0xa2,0x0
; 76  L
 .db  0x3,0xbe,0x82,0x82,0x0,0x0
; 77  M
 .db  0x5,0xbe,0x10,0x8,0x10,0x3e
; 78  N
 .db  0x5,0xbe,0x10,0x8,0x4,0xbe
; 79  O
 .db  0x4,0x9c,0xa2,0xa2,0x9c,0x0
; 80  P
 .db  0x4,0xbe,0xa8,0xa8,0x98,0x0
; 81  Q
 .db  0x5,0x9c,0xa2,0xaa,0xa4,0x9a
; 82  R
 .db  0x4,0xbe,0xa8,0xac,0x9a,0x0 ;0x4,0xbe,0xa8,0xac,0x92,0x0
; 83  S
 .db  0x4,0x92,0xaa,0xaa,0xa4,0x80
; 84  T
 .db  0x4,0xa0,0xbe,0xa0,0xa0,0x0
; 85  U
 .db  0x4,0xbc,0x82,0x82,0xbe,0x0
; 86  V
 .db  0x5,0x38,0x4,0x82,0x84,0xb8 ;0x4,0x38,0x84,0x82,0xbc,0x00
; 87  W
 .db  0x5,0x3e,0x86,0x88,0x06,0xbe ;0x5,0x3e,0x2,0x8c,0x2,0xbe
; 88  X
 .db  0x5,0xa2,0x94,0x88,0x94,0xa2
; 89  Y
 .db  0x4,0xb0,0x8a,0x8c,0xb0,0x80
; 90  Z
 .db  0x5,0xa2,0xa6,0xaa,0xb2,0xa2
; 91  [
 .db  0x3,0x94,0xa2,0xa2,0x0,0x0
; 92  \
 .db  0x5,0xa0,0x90,0x88,0x84,0x82
; 93  ]
 .db  0x3,0xa2,0xa2,0x94,0x0,0x0
; 94  ^
 .db  0x5,0x88,0x90,0xa0,0x90,0x88
; 95  _
 .db  0x4,0x82,0x82,0x82,0x82,0x0
; 96  `
 .db  0x5,0x9f,0x15,0x21,0x95,0x1f
; 97  a
 .db  0x3,0xac,0xaa,0xbe,0x80,0x0
; 98  b
 .db  0x3,0xbe,0x8a,0x8e,0x80,0x0
; 99  c
 .db  0x3,0x8c,0x92,0x92,0x80,0x0
; 100  d
 .db  0x3,0x8e,0x8a,0xbe,0x80,0x0
; 101  e
 .db  0x3,0x9c,0xaa,0x9a,0x80,0x0
; 102  f
 .db  0x3,0x88,0x9e,0xa8,0x80,0x0
; 103  g
 .db  0x3,0xb2,0xaa,0x9e,0x80,0x0
; 104  h
 .db  0x3,0xbe,0x88,0x8e,0x80,0x0
; 105  i
 .db  0x1,0xae,0x80,0x80,0x0,0x0
; 106  j
 .db  0x3,0x84,0x82,0xae,0x80,0x0
; 107  k
 .db  0x3,0xbe,0x84,0x8a,0x80,0x0
; 108  l
 .db  0x1,0xbe,0x80,0x80,0x80,0x0
; 109  m
 .db  0x5,0x8e,0x8,0x4,0x8,0xe
; 110  n
 .db  0x3,0x9e,0x88,0x8e,0x80,0x80
; 111  o
 .db  0x3,0x8c,0x92,0x8c,0x80,0x0
; 112  p
 .db  0x3,0xbe,0xa8,0x98,0x80,0x0
; 113  q
 .db  0x3,0x18,0xa8,0xbe,0x80,0x80
; 114  r
 .db  0x3,0x9e,0x88,0x8c,0x80,0x0
; 115  s
 .db  0x3,0x92,0xaa,0xa4,0x80,0x80
; 116  t
 .db  0x3,0x90,0xbe,0x90,0x80,0x0
; 117  u
 .db  0x4,0x9c,0x82,0x82,0x9e,0x0
; 118  v
 .db  0x4,0x1c,0x82,0x84,0x98,0x80
; 119  w
 .db  0x5,0xe,0x2,0x84,0x2,0x8e
; 120  x
 .db  0x4,0x92,0x8c,0x8c,0x92,0x80
; 121  y
 .db  0x4,0x92,0xa,0x84,0x98,0x80
; 122  z
 .db  0x4,0x92,0x96,0x9a,0x92,0x80
; try not to have single pixel in first or last columns
; the last character in cset2 is 122, so add on a few more to get to 127..
; 123  ?
 .db  0x4,0x90,0xa0,0xab,0x90,0x0
; 124 ?
 .db  0x4,0x90,0xa0,0xab,0x90,0x0
; 125  ?
 .db  0x4,0x90,0xa0,0xab,0x90,0x0
; 126 ?
 .db  0x4,0x90,0xa0,0xab,0x90,0x0
; 127  ?
 .db  0x4,0x90,0xa0,0xab,0x90,0x0



 
begin:    clr	ZREG
	ldi 	ACCA,0xFF
	mov	FFREG,acca
;pins
    ldi ACCB,0x0f
	out DDRA,ACCB	; lower four bits are outputs
	ldi ACCB,0b11100000 ; pb4...pb0 are inputs
	out DDRB,ACCB
	out DDRD,ZREG  ; all inputs for now
    ldi ACCB,0x02  ; set pullup on pC1, set 'scope 0, toggle 0
	out PORTC,ACCB
    ldi ACCB,0b11111101
    out DDRC,ACCB ; only pC1 is input
;
    ldi ACCB,0b11110000
	out PORTA,ACCB ; switch on pullups, D/A 000
	ldi ACCB,0b00011111
	out PORTB,ACCB  ; set mosi bits to 0, pullups on for switch
    out PORTD,FFREG
;
    SBI	DDRD,1	; ensure the UART pin is output
    SBI    DDRD,4    ; ensure OC1B is output for toggle
    SBI    DDRD,5    ; ensure OC1A is output for toggle
    SBI    DDRD,7    ; 500Hz test square wave output
	CBI	DDRD,0	; ensure the UART pin is input
;
;
; clear internal registers
	ldi ZH,0
	ldi zl,0x1e	; YH
clfile:	st -Z,zh	; clr R0..R29, ignore warning (set error off for assembler)
	tst zl
	brne clfile
;
    in PBCpy,PINB ; latch pB4 (after clfile)
;
    clr	ZREG
	ldi 	ACCA,0xFF
	mov	FFREG,ACCA
; set up stack
	LDy	RAMEND 
	OUT	SPL,yl		;init Stack Pointer
	OUT	SPH,yh
;
; now clear RAM
     ldz	0x0068 
clr1: st Z,FFREG
      ld ACCB,Z
      cpi ACCB,0xff
      brne wtreset
     st	Z,zreg ; store a zero
	ld 	acca,Z+
	tst acca
	breq clr22
; ramerror
wtreset: cli	; don't allow interrupt
	ldi ACCA,0x09
	out WDTCR,ACCA ; enable watchdog
	ldi ACCA,(1<<SE)	; idle mode (might be from ramerror)
	out MCUCR,ACCA
w4reset: sleep
	rjmp w4reset ; 	for reset to initalise all SFRegisters

clr22:	cp ZH,yh ; reached RAMEND?
	brlo	clr1
	cp ZL,yl       ; reached RAMEND?
	brlo	clr1   
;
      ldi PCNT,1
      rcall setop ; set o/p to underline and initialise tonH, tonL
;
;setup timer2 
    ldi ACCB,50  ; 50mS int time timer2
    clr TCNT
    mov TCNTms,ACCB
    ldi ACCA,249 ; 250-1
    out OCR2,ACCA ; every 1mS
	 ldi ACCA,'0'
	 sts QRS,ACCA
    rcall setqrs
  ;;  ldi ACCA,0x1B ; toggle pD7, timer 2 clk/32, CTC
 ;;   out TCCR2,ACCA
;
; setup timer1
    ldi ACCA,0x50
    out TCCR1A,ACCA ; toggle pin 19 pD5 OC1A and pin18 OC1B
	ldi ACCA,9	; set up timer1 clock CTC
	out TCCR1B,acca	; timer 1 clock is 8Mhz
;
; enable timer2 interrupt
    ldi ACCA,(1<<OCIE2) ;12
    out TIMSK,ACCA   ; OCF1A (not yet enabled) and timer 2
;
; set UART buadrate
	ldi ACCB,0x00
	Ldi ACCA,51	; 8Mhz 9600
	out UBRRH,ACCB
	out UBRRL,ACCA
;
; enable UART tx (and maybe rx)
	ldi ACCA,0b10000110	; 8bits
	out UCSRC,ACCB
	ldi ACCA,(1<<TXEN)
    sbrs PBCpy,4 ; only enable receive if PB4 is 0
    ori  ACCA, (1<<RXEN)
	out UCSRB,ACCA ; enable transmit
	rcall docr
;
	 mov TILT,zreg
	
     ldi ACCA,'1' ; default cset1
	 sts csel,ACCA
	 ldz (cset2<<1)
	 lpm ACCA,Z
	 andi ACCA,0x0f ; mod mv4
	 cpi ACCA,3
	 brlo sndsign ; 0?
	 cpi ACCA,6
	 brsh sndsign ; ff?
	 ldi ACCA,'2'
	 sts csel,ACCA ; select cset2

; send signon messages
sndsign:    do_sndmsg "see www.qsl.net/zs1agx/shell/shell.html for pb4..0 settings"
    rcall docr
    do_sndmsg "pB4...pB0: "
    ldi TEMP1,5
    mov ACCB,PBCpy
sndpb: ldi ACCA,'0'
    sbrc ACCB,4
    ldi ACCA,'1'
    rcall sdcr2 ; do 101 send
    dec TEMP1
    breq on3
    lsl ACCB
    rjmp sndpb

on3: do_sndmsg "  mode "
    mov ACCA,PBCpy
    andi ACCA,7
    subi ACCA,-0x30 ; (addi ACCA,0x30)
    rcall sdcr2
    do_sndmsg " v1.04 "
    rcall docr
	rcall lodstat  ; will   rcall setqrs
	rcall showstat
    rcall loadee
	cpi ACCA,1
	breq elok
    do_sndmsg "no message found "
    rcall docr
    rcall testmsg
    do_sndmsg "loaded !TEST message "
     rcall docr
elok:    sbrc PBCpy,4
    rjmp pmode2
    do_sndmsg "Type in message, then !SAVE"
pmode2: rcall docr
;
; maybe enable UART rxint
    sbrc PBCpy,4 ; only enable UART int if PB4 is 0
    rjmp on4
; 
   sbi UCSRB,7	; int on rxchar (live mode only)
   cbr SERIAL,(1<<ECHOM) ; allow DRE int (reset bit after do_sndmsg)
;
; set initial program conditions
on4: sbr STAT,(1<<b_NXTCHR)
     sts chrix,zreg ; nrr
	 wdr
	ldi ACCA,0x0e  ;  1110 (1sec >> column time)
    sbrc PBCpy,4 ; only enable WDT int if PB4 is 1
	out WDTCR,ACCA ; enable watchdog
    rjmp wtint
;
showstat: do_sndmsg "CSET="
    lds ACCA,CSEL
    rcall sdcr2
    tst TILT
	breq sstat2
    do_sndmsg " TILT="
    mov ACCB,TILT
    ldi ACCA,'-'
    sbrc ACCB,7
    rcall sdcr2
    mov ACCA,ACCB
    andi ACCA,0x07
    ori ACCA,0x30
    rcall sdcr2
    rjmp docr
;
sstat2:    do_sndmsg " SLOW="
    lds ACCA,QRS
    rcall sdcr2
    rjmp docr
	;


showstat2: ldx tbuff
	ldz ssmsg<<1
	rcall see0
	in ACCA,PINB
	andi ACCA,7
	ori ACCA,0x30
	st X+,ACCA
;
;;	ldx tbuff
	ldz ssmsg0<<1
	rcall see0
	lds ACCA,CSEL
	st X+,ACCA
;
    tst TILT
    breq see2 ; simplify display
	ldz ssmsg1<<1
	rcall see0
;
	mov ACCB,TILT
	ldi ACCA,'-'
    sbrc ACCB,7
    st X+,ACCA
    mov ACCA,ACCB
    andi ACCA,0x07
    ori ACCA,0x30
	st X+,ACCA
	
	ldi ACCA,0x30
	sts QRS,ACCA ; set QRS='0' if TILT .nz.
    ret
;
see2: lds ACCA,QRS
      cpi ACCA,0x30
      breq seeout ; simplify display
     ldz ssmsg2<<1
	rcall see0
	lds ACCA,QRS
	st X+,ACCA
seeout: ret
	;
see0:	lpm ACCA,Z+
	st X,ACCA
	TST ACCA
	breq seem
	adiw xl,1
	rjmp see0
seem: ret

ssmsg: .db "MODE=",0	
ssmsg0: .db " CSET=",0
ssmsg1: .db " TILT=",0
ssmsg2: .db " SLOW=",0
		
; polling type UART send used for signon messages at startup
; sndmsl called from do_sndmsg
sndmsl: sbr SERIAL,(1<<ECHOM)  ; busy sending now.. set ignore rx
sndmsl2:  lpm ACCA,Z+
      tst ACCA
      breq sndmsl2 ; ignore 00
     cpi ACCA,0x80 ; >=0x80 is end of text message
     brlo scr02
     ret
;
scr02: sbis UCSRA,5
	rjmp scr02 ; wait until last sent
	out UDR,ACCA
    rjmp sndmsl2
;
docr: ldi ACCA,0x0d
sdcr2:	sbis UCSRA,5
	rjmp sdcr2
	out UDR,ACCA
    ret
;
tabt2:  .db 0b00011011 , 0b00011100 ; ;0x1B ; toggle pD7, timer 2 clk/32, CTC   / 64
		.db 0b00011101 , 0b00011110 ;; /128 256
		.db 0b00011111 , 0b00011111 ; /1024
		
setqrs: ldi ACCA,0x02
		out SFIOR,ACCA ;reset the prescaler
		ldz (tabt2<<1)
		lds acca,QRS
		andi ACCA,7
		cpse ACCA,zreg
		clr TILT ; if QRS is .nz. then disable TILT
		add zl,ACCA
		adc zh,zreg
		lpm ACCA,Z+
		out TCCR2,ACCA
		ret
;
;========================== looper ===
; now wait for interrupt
wtint:	sei
	ldi ACCA,(1<<SE)	; idle mode 
	out MCUCR,ACCA
 ;    sbrs STAT,b_tic1ms ; was it 1mS int?
	sleep
    sbrs STAT,b_tic1ms ; was it 1mS int?
	rjmp cklive  ;   no, check livemode
    cbr STAT,(1<<b_tic1ms)
    sbrs STAT,b_NXTCHR
    rjmp wtchr ; continue current character
    cbr STAT,(1<<b_NXTCHR)
    rcall nxtchr ; start new character
    rjmp wtint
;===============================
;
; check UART receive
cklive:    sbrc PBCpy,4
      rjmp wtint
      sbrs SERIAL,GOTLINE	; did get message with <cr> ?
	  rjmp wtint
      rcall livemode
      rjmp wtint

wtchr: cbi PORTC,0   ; reset 'scope trigger
    ldx cbuf
    lds ACCB,cbix
    add xl,ACCB
    ld ACCA,X
    tst ACCA ; move to next ?
    breq mnxcol
    rcall lppix ;    continue this column
    rjmp wtint
; 
; move to next column
mnxcol: clr PCNT   ; moving to next column
    inc ACCB
    sts cbix,ACCB
    cp ACCB,colcnt  ; colcnt is 4 for cbix running 0...3
    brsh allsent ; do between char underline
    rcall dnxtcol ; do next column
    rjmp wtint

; everything has been sent, do between character underline
allsent:  sbrc rmv4,b_notrail
	rjmp allsentnt ; no trailing underline
	ldi PCNT,1
	sts cbix,zreg
    rcall setop
	ldi ACCB,200 ; 200 mS between characters, becomes 100mS for b1=0
    rcall setim
    sbr STAT,(1<<b_NXTCHR) ; flag to move to next character 
    in PBCpy,PINB ; allow mode change/character (b4 was latched for rx/rxint enable)
    rjmp wtint
;
; mod mv4 skip trail underline
allsentnt:	rcall nxtchr
	rjmp wtint
;
gettilde: ldz tildebuf
          ld ACCB,Z+
       andi ACCB,7
       breq nxtchr      ; invalid character since col count=0
   	;
    ;;   sbrc PBCpy,0      ; pinb LSB is normally '1' for double up
    ;;   lsl ACCB ; (double the column count)
       mov colcnt,ACCB
       ldx cbuf       ; point to char/col buffer
; store everything twice if double up columns
       ld ACCA,Z+     ; get col 1
       st X+,ACCA
     ;;  sbrc PBCpy,0      ; pinb LSB is normally '1' for double up
    ;;   st X+,ACCA
       ld ACCA,Z+     ; get col 2
       st X+,ACCA
     ;;  sbrc PBCpy,0      ; pinb LSB is normally '1' for double up
    ;;   st X+,ACCA
       ld ACCA,Z+     ; get col 3
       st X+,ACCA
     ;;  sbrc PBCpy,0      ; pinb LSB is normally '1' for double up
     ;;  st X+,ACCA
       ld ACCA,Z+     ; get col 4
       st X+,ACCA
     ;;  sbrc PBCpy,0      ; pinb LSB is normally '1' for double up
     ;;  st X+,ACCA
       ld ACCA,Z+     ; get col 5
       st X+,ACCA
     ;;  sbrc PBCpy,0      ; pinb LSB is normally '1' for double up
     ;;  st X+,ACCA
	 	cbr PBCpy,0x03 ; 0x02 allow 100mS - 0x01 no double columns for 0x27 and 0x60
       rjmp dnxtc0
;
; for char 126, x27 and x60, b1 and b0 are cleared: cbr PBCpy,0x03 
; b0 cleared skips the double up at alwdbl, and
; b1 cleared allows 100mS pixels
;
nxtchr: rcall getcix    ; get pointer to char in Z
       cpi ACCA,126
       breq gettilde
       lpm ACCB,Z+     ; get number of col
	   mov rmv4,ACCB ; remember hi nibble 
       andi ACCB,7
       breq nxtchr      ; invalid character since col count=0
;		
		sbrc rmv4,b_norpt ; mod mv4 ,if bit 0x20 ,them send char single column timing (no repeat)
		rjmp notdbl
		cpi ACCA,0x27
		breq notdbl
		cpi ACCA,0x60
		brne alwdbl
notdbl:	cbr PBCpy,0x03 ; no double columns for 0x27 and 0x60
alwdbl: sbrc PBCpy,0      ; pinb LSB is normally '1' for double up
       lsl ACCB ; (double the column count)
       mov colcnt,ACCB
       ldx cbuf       ; point to char/col buffer
; store everything twice if double up columns
       lpm ACCA,Z+     ; get col 1
       st X+,ACCA
       sbrc PBCpy,0      ; pinb LSB is normally '1' for double up
       st X+,ACCA
       lpm ACCA,Z+     ; get col 2
       st X+,ACCA
       sbrc PBCpy,0      ; pinb LSB is normally '1' for double up
       st X+,ACCA
       lpm ACCA,Z+     ; get col 3
       st X+,ACCA
       sbrc PBCpy,0      ; pinb LSB is normally '1' for double up
       st X+,ACCA
       lpm ACCA,Z+     ; get col 4
       st X+,ACCA
       sbrc PBCpy,0      ; pinb LSB is normally '1' for double up
       st X+,ACCA
       lpm ACCA,Z+     ; get col 5
       st X+,ACCA
       sbrc PBCpy,0      ; pinb LSB is normally '1' for double up
       st X+,ACCA

dnxtc0:       sbi PORTC,0   ; set 'scope trigger at start first column of new char
       sts cbix,zreg  ; point to first set
;
dnxtcol: clr PCNT        ; start of new column
       ldx cbuf
       lds ACCA,cbix
       add xl,ACCA    ; index into cbuf
       ld ACCA,X
       mov thiscol,ACCA ; remember top bit for drawup/down
       andi ACCA,0x3f ; six pixels only
	 ;  cpi ACCA,0x3f ; really don't want all six pixels on at same time since this would be 18mS
	 ;  brne notall   ; there should be neither 3f nor bf ($) in cset2, but the bctab has 20mS at 3f
	 ;  ldi ACCA,0x3e ; don't allow all pixels in column
notall: st X,ACCA       ; set pixels for this column
       mov ACCB,ACCA ; use pixel pattern to count '1's and calculate time for each
       rcall setptime ; doesn't affect ACCA
;
       ldi PCNT,1;√ 
       tst ACCA
       breq setop ; the pixels are all 0, so set op to 1
      sbrc thiscol,b_drawup
       rjmp lppix ;√ lsb is first pixel to send
       ldi PCNT,8
    
       lsl ACCA
       lsl ACCA ;msb is now first pixel to send
; ACCA must be non-zero now!
lppix: sbrc thiscol,b_drawup
       inc PCNT ;√ first pixel at 2 for  2,3,4,5,6,7
       sbrs thiscol,b_drawup
       dec PCNT ; first pixel at 7 for 7,6,5,4,3,2
       sbrc thiscol,b_drawup
       lsr ACCA ;√
       sbrs thiscol,b_drawup
       lsl ACCA
       st X,ACCA ; set remaining pixels for this column
       brcc lppix ; don't send 0 pixels
setop:   mov ACCB,PCNT ; can't exceed 7
	   lds TEMP1,cbix
	   sbrs TEMP1,0
	   ori ACCB,0x08 ;pA4 must be H level column 0,2,4
	   ldi TEMP1,0x0f ; for xor
       sbrs PBCpy,3 ; b3 is invert 
       eor ACCB,TEMP1
       andi ACCB,0x0f ; output on a2 a1 a0
; ACCB b3...b0 now has lowermost 4 bits for PORTA output  
	   ldi ACCA,0xf0  ;  ; in ACCA,PORTA    andi ACCA,0xf0  ; keep output bits
       or ACCA,ACCB
       out PORTA,ACCA ; to ensure bias on varactor, the count is not below 001 or above 110
	   andi ACCB,0x07 ; clear toggle b3
	   lsl ACCB ; each entry is two bytes
	   tst TILT
	   brne trytilt
;
	   lds ACCA,QRS
	   ldz (tontab<<1)
		andi ACCA,7
		swap ACCA ;;ldi TEMP1,16  mul TEMP1,ACCA
		add zl,ACCA
		adc zh,zreg
	   add zl,ACCB
	   adc zh,zreg
	   rjmp tdun
; 
trytilt: mov ACCA,TILT
		ldz (ntontab10<<1) 
		andi ACCA,3
		cpi ACCA,3
		breq setop2
		ldz (ntontab5<<1) 
		cpi ACCA,2
		breq setop2
		ldz (ntontab25<<1) ;1 01 

;
setop2: ldi TEMP1,21
		mul ACCB,TEMP1
	   add zl,r0
       adc zh,r1
	   lds ACCB,cbix ; 0..10
	   tst ACCB
	   breq tdun
;
	   adiw zl,2  ; now for col 1
	   dec ACCB
	   lsl ACCB	  ; four bytes each pair
	   lsl ACCB  
	   add zl,ACCB ; col 1 adds on 0
	   adC zh,zreg ; col 2 adds on 4
; check for '-'
		mov ACCA,TILT
	   sbrc ACCA,7 ; this is '-' TILT
	   adiw zl,2
  
tdun:  cli			; disable int
	   lpm tonL,Z+ 	; read first byte of LPM is low
       lpm tonH,Z+
       ldi ACCA,(1<<OCF1A) ; clear last compare flag
       out TIFR,ACCA
       ldi ACCB,(1<<OCIE2)| (1<<OCIE1A) 
       out TIMSK,ACCB ; allow compA int
	   sei		; re-enable int
       ret

; test tone from pD5, for I+Q, increase these frequencies
tontab: .dw 2666,  2580,  2499,  2423,  2352,  2285,  2221,  2161
;  1499.8  1549.7  1600  1650.1  1699.9  1749.7  1800.1  1850.1
 .dw 2666,  2622,  2580,  2539,  2499,  2461,  2423,  2387
 ;  1499.8  1524.9  1549.7  1574.8  1600  1624.6  1650.1  1675.0
 .dw 2666,  2639,  2613,  2588,  2563,  2539,  2515,  2491
 ;  1499.8  1515.1  1530.2  1544.9  1560.0  1574.8  1589.8  1605.1
 .dw 2666,  2652,  2638,  2624,  2610,  2596,  2583,  2570
 ;  1499.8  1507.7  1515.7  1523.8  1531.9  1540.2  1547.9  1555.8
 .dw 2666,  2659,  2652,  2645,  2638,  2631,  2624,  2617
 ;  1499.8  1503.7  1507.7  1511.7  1515.7  1519.7  1523.8  1527.8

 
;
; 21 entries for each line
ntontab25: ; 2.5Hz
.dw  2666,  2661,  2670,  2657,  2675,  2652,  2679,  2648,  2684,  2644,  2688,  2639,  2693,  2635,  2697,  2631,  2702,  2626,  2706,  2622,  2711
;  1500  1502.5  1497.5  1505  1495  1507.5  1492.5  1510  1490  1512.5  1487.5  1515  1485  1517.5  1482.5  1520  1480  1522.5  1477.5  1525  1475
 .dw  2580,  2575,  2584,  2571,  2588,  2567,  2592,  2563,  2596,  2559,  2601,  2555,  2605,  2551,  2609,  2547,  2613,  2543,  2618,  2539,  2622
 ;  1550  1552.5  1547.5  1555  1545  1557.5  1542.5  1560  1540  1562.5  1537.5  1565  1535  1567.5  1532.5  1570  1530  1572.5  1527.5  1575  1525
 .dw  2499,  2495,  2503,  2491,  2507,  2487,  2511,  2483,  2515,  2480,  2519,  2476,  2523,  2472,  2527,  2468,  2531,  2464,  2535,  2461,  2539
 ;  1600  1602.5  1597.5  1605  1595  1607.5  1592.5  1610  1590  1612.5  1587.5  1615  1585  1617.5  1582.5  1620  1580  1622.5  1577.5  1625  1575
 .dw  2423,  2420,  2427,  2416,  2431,  2412,  2434,  2409,  2438,  2405,  2442,  2401,  2445,  2398,  2449,  2394,  2453,  2391,  2457,  2387,  2461
 ;  1650  1652.5  1647.5  1655  1645  1657.5  1642.5  1660  1640  1662.5  1637.5  1665  1635  1667.5  1632.5  1670  1630  1672.5  1627.5  1675  1625
 .dw  2352,  2348,  2355,  2345,  2359,  2342,  2362,  2338,  2366,  2335,  2369,  2331,  2373,  2328,  2376,  2325,  2380,  2321,  2384,  2318,  2387
 ;  1700  1702.5  1697.5  1705  1695  1707.5  1692.5  1710  1690  1712.5  1687.5  1715  1685  1717.5  1682.5  1720  1680  1722.5  1677.5  1725  1675
 .dw  2285,  2281,  2288,  2278,  2291,  2275,  2295,  2272,  2298,  2269,  2301,  2265,  2304,  2262,  2308,  2259,  2311,  2256,  2314,  2253,  2318
 ;  1750  1752.5  1747.5  1755  1745  1757.5  1742.5  1760  1740  1762.5  1737.5  1765  1735  1767.5  1732.5  1770  1730  1772.5  1727.5  1775  1725
 .dw  2221,  2218,  2224,  2215,  2227,  2212,  2231,  2209,  2234,  2206,  2237,  2203,  2240,  2200,  2243,  2197,  2246,  2194,  2249,  2191,  2253
 ;  1800  1802.5  1797.5  1805  1795  1807.5  1792.5  1810  1790  1812.5  1787.5  1815  1785  1817.5  1782.5  1820  1780  1822.5  1777.5  1825  1775
 .dw  2161,  2158,  2164,  2155,  2167,  2152,  2170,  2150,  2173,  2147,  2176,  2144,  2179,  2141,  2182,  2138,  2185,  2135,  2188,  2132,  2191
 ;  1850  1852.5  1847.5  1855  1845  1857.5  1842.5  1860  1840  1862.5  1837.5  1865  1835  1867.5  1832.5  1870  1830  1872.5  1827.5  1875  1825
 .dw  2104,  2101,  2107,  2099,  2110,  2096,  2113,  2093,  2115,  2091,  2118,  2088,  2121,  2085,  2124,  2082,  2127,  2080,  2129,  2077,  2132
 ;  1900  1902.5  1897.5  1905  1895  1907.5  1892.5  1910  1890  1912.5  1887.5  1915  1885  1917.5  1882.5  1920  1880  1922.5  1877.5  1925  1875
 .dw  2050,  2048,  2053,  2045,  2056,  2042,  2058,  2040,  2061,  2037,  2064,  2035,  2066,  2032,  2069,  2029,  2072,  2027,  2074,  2024,  2077
 ;  1950  1952.5  1947.5  1955  1945  1957.5  1942.5  1960  1940  1962.5  1937.5  1965  1935  1967.5  1932.5  1970  1930  1972.5  1927.5  1975  1925
 .dw  1999,  1997,  2002,  1994,  2004,  1992,  2007,  1989,  2009,  1987,  2012,  1984,  2014,  1982,  2017,  1979,  2019,  1977,  2022,  1974,  2024
 ;  2000  2002.5  1997.5  2005  1995  2007.5  1992.5  2010  1990  2012.5  1987.5  2015  1985  2017.5  1982.5  2020  1980  2022.5  1977.5  2025  1975

ntontab5:
.dw  2666,  2657,  2675,  2648,  2684,  2639,  2693,  2631,  2702,  2622,  2711,  2613,  2720,  2605,  2729,  2596,  2739,  2588,  2748,  2580,  2758
;  1500  1505  1495  1510  1490  1515  1485  1520  1480  1525  1475  1530  1470  1535  1465  1540  1460  1545  1455  1550  1450
 .dw  2580,  2571,  2588,  2563,  2596,  2555,  2605,  2547,  2613,  2539,  2622,  2531,  2631,  2523,  2639,  2515,  2648,  2507,  2657,  2499,  2666  
 ;  1550  1555  1545  1560  1540  1565  1535  1570  1530  1575  1525  1580  1520  1585  1515  1590  1510  1595  1505  1600  1500
 .dw  2499,  2491,  2507,  2483,  2515,  2476,  2523,  2468,  2531,  2461,  2539,  2453,  2547,  2445,  2555,  2438,  2563,  2431,  2571,  2423,  2580 
 ;  1600  1605  1595  1610  1590  1615  1585  1620  1580  1625  1575  1630  1570  1635  1565  1640  1560  1645  1555  1650  1550
 .dw  2423,  2416,  2431,  2409,  2438,  2401,  2445,  2394,  2453,  2387,  2461,  2380,  2468,  2373,  2476,  2366,  2483,  2359,  2491,  2352,  2499 
 ;  1650  1655  1645  1660  1640  1665  1635  1670  1630  1675  1625  1680  1620  1685  1615  1690  1610  1695  1605  1700  1600
 .dw  2352,  2345,  2359,  2338,  2366,  2331,  2373,  2325,  2380,  2318,  2387,  2311,  2394,  2304,  2401,  2298,  2409,  2291,  2416,  2285,  2423 
 ;  1700  1705  1695  1710  1690  1715  1685  1720  1680  1725  1675  1730  1670  1735  1665  1740  1660  1745  1655  1750  1650
 .dw  2285,  2278,  2291,  2272,  2298,  2265,  2304,  2259,  2311,  2253,  2318,  2246,  2325,  2240,  2331,  2234,  2338,  2227,  2345,  2221,  2352 
 ;  1750  1755  1745  1760  1740  1765  1735  1770  1730  1775  1725  1780  1720  1785  1715  1790  1710  1795  1705  1800  1700
 .dw  2221,  2215,  2227,  2209,  2234,  2203,  2240,  2197,  2246,  2191,  2253,  2185,  2259,  2179,  2265,  2173,  2272,  2167,  2278,  2161,  2285 
 ;  1800  1805  1795  1810  1790  1815  1785  1820  1780  1825  1775  1830  1770  1835  1765  1840  1760  1845  1755  1850  1750
 .dw  2161,  2155,  2167,  2150,  2173,  2144,  2179,  2138,  2185,  2132,  2191,  2127,  2197,  2121,  2203,  2115,  2209,  2110,  2215,  2104,  2221 
 ;  1850  1855  1845  1860  1840  1865  1835  1870  1830  1875  1825  1880  1820  1885  1815  1890  1810  1895  1805  1900  1800
 .dw  2104,  2099,  2110,  2093,  2115,  2088,  2121,  2082,  2127,  2077,  2132,  2072,  2138,  2066,  2144,  2061,  2150,  2056,  2155,  2050,  2161 
 ;  1900  1905  1895  1910  1890  1915  1885  1920  1880  1925  1875  1930  1870  1935  1865  1940  1860  1945  1855  1950  1850
 .dw  2050,  2045,  2056,  2040,  2061,  2035,  2066,  2029,  2072,  2024,  2077,  2019,  2082,  2014,  2088,  2009,  2093,  2004,  2099,  1999,  2104 
 ;  1950  1955  1945  1960  1940  1965  1935  1970  1930  1975  1925  1980  1920  1985  1915  1990  1910  1995  1905  2000  1900
 .dw  1999,  1994,  2004,  1989,  2009,  1984,  2014,  1979,  2019,  1974,  2024,  1969,  2029,  1965,  2035,  1960,  2040,  1955,  2045,  1950,  2050 
 ;  2000  2005  1995  2010  1990  2015  1985  2020  1980  2025  1975  2030  1970  2035  1965  2040  1960  2045  1955  2050  1950

ntontab10:
 .dw  2666,  2648,  2684,  2631,  2702,  2613,  2720,  2596,  2739,  2580,  2758,  2563,  2777,  2547,  2796,  2531,  2816,  2515,  2836,  2499,  2856  
 ;  1500  1510  1490  1520  1480  1530  1470  1540  1460  1550  1450  1560  1440  1570  1430  1580  1420  1590  1410  1600  1400
 .dw  2580,  2563,  2596,  2547,  2613,  2531,  2631,  2515,  2648,  2499,  2666,  2483,  2684,  2468,  2702,  2453,  2720,  2438,  2739,  2423,  2758  
 ;  1550  1560  1540  1570  1530  1580  1520  1590  1510  1600  1500  1610  1490  1620  1480  1630  1470  1640  1460  1650  1450
 .dw  2499,  2483,  2515,  2468,  2531,  2453,  2547,  2438,  2563,  2423,  2580,  2409,  2596,  2394,  2613,  2380,  2631,  2366,  2648,  2352,  2666 
  ;  1600  1610  1590  1620  1580  1630  1570  1640  1560  1650  1550  1660  1540  1670  1530  1680  1520  1690  1510  1700  1500
 .dw  2423,  2409,  2438,  2394,  2453,  2380,  2468,  2366,  2483,  2352,  2499,  2338,  2515,  2325,  2531,  2311,  2547,  2298,  2563,  2285,  2580 
  ;  1650  1660  1640  1670  1630  1680  1620  1690  1610  1700  1600  1710  1590  1720  1580  1730  1570  1740  1560  1750  1550
 .dw  2352,  2338,  2366,  2325,  2380,  2311,  2394,  2298,  2409,  2285,  2423,  2272,  2438,  2259,  2453,  2246,  2468,  2234,  2483,  2221,  2499 
  ;  1700  1710  1690  1720  1680  1730  1670  1740  1660  1750  1650  1760  1640  1770  1630  1780  1620  1790  1610  1800  1600
 .dw  2285,  2272,  2298,  2259,  2311,  2246,  2325,  2234,  2338,  2221,  2352,  2209,  2366,  2197,  2380,  2185,  2394,  2173,  2409,  2161,  2423 
  ;  1750  1760  1740  1770  1730  1780  1720  1790  1710  1800  1700  1810  1690  1820  1680  1830  1670  1840  1660  1850  1650
 .dw  2221,  2209,  2234,  2197,  2246,  2185,  2259,  2173,  2272,  2161,  2285,  2150,  2298,  2138,  2311,  2127,  2325,  2115,  2338,  2104,  2352 
  ;  1800  1810  1790  1820  1780  1830  1770  1840  1760  1850  1750  1860  1740  1870  1730  1880  1720  1890  1710  1900  1700
 .dw  2161,  2150,  2173,  2138,  2185,  2127,  2197,  2115,  2209,  2104,  2221,  2093,  2234,  2082,  2246,  2072,  2259,  2061,  2272,  2050,  2285  
 ;  1850  1860  1840  1870  1830  1880  1820  1890  1810  1900  1800  1910  1790  1920  1780  1930  1770  1940  1760  1950  1750
 .dw  2104,  2093,  2115,  2082,  2127,  2072,  2138,  2061,  2150,  2050,  2161,  2040,  2173,  2029,  2185,  2019,  2197,  2009,  2209,  1999,  2221 
  ;  1900  1910  1890  1920  1880  1930  1870  1940  1860  1950  1850  1960  1840  1970  1830  1980  1820  1990  1810  2000  1800
 .dw  2050,  2040,  2061,  2029,  2072,  2019,  2082,  2009,  2093,  1999,  2104,  1989,  2115,  1979,  2127,  1969,  2138,  1960,  2150,  1950,  2161 
  ;  1950  1960  1940  1970  1930  1980  1920  1990  1910  2000  1900  2010  1890  2020  1880  2030  1870  2040  1860  2050  1850
 .dw  1999,  1989,  2009,  1979,  2019,  1969,  2029,  1960,  2040,  1950,  2050,  1941,  2061,  1931,  2072,  1922,  2082,  1913,  2093,  1904,  2104  
 ;  2000  2010  1990  2020  1980  2030  1970  2040  1960  2050  1950  2060  1940  2070  1930  2080  1920  2090  1910  2100  1900
;
; only from setall (dnxtcol)
setptime: ;;ldz (bctab50<<1) ; b1 = 1 ; single pixels are 50mS
		;;sbrc pbCpy,1
		;;rjmp setpt2
	   ldz (bctab100<<1) ; b1=0 single pixel width to 100mS
setpt2: andi ACCB,0x3f
       add zl,ACCB
       adc zh,ZREG
       lpm ACCB,Z   ; this now holds number of milliseconds/pix for col
	  sbrc rmv4,b_singpix ; mod mv4
	  rjmp setpt3 ; if the bit is 1, allow 100mS pixels
	  sbrs pbCpy,1
	   rjmp setpt3 ; if the bit is 0, allow 100mS pixels
	   sbrc pbCpy,0
	   rjmp setpdc ; branch for double col
	   ; single column mode, limit pixel to 75mS
	   cpi ACCB,75
	   brlo setpt3
	   ldi ACCB,75 ; if the bit is '1' , limit pixel width to 75mS
	   rjmp setpt3
setpdc:  cpi ACCB,50
	   brlo setpt3
	   ldi ACCB,50 ; if the bit is '1' , limit pixel width to 50mS
	   rjmp setpt3
setpt3: sbrs PBCpy,2
       ldi ACCB,50  ; fixed time for col
setim:  ;; cli	; don't allow interrupt
     ;  sbrs PBCpy,1 ; b1 is 0 for double speed
     ;;  lsr ACCB
     ;;  mov TCNT,ACCB ; this isn't accurate, should addon instead...
       mov TCNTms,ACCB
     ;;  cbr STAT,(1<<b_tic1ms)
     ;;  sei    ; re-enable int
       ret

; getcix returns ZH:ZL pointing to cset for character in msgbuff
getcix: ldx msgbuff  ; point to message
        lds ACCA,chrix
        mov ACCB,ACCA ; keep old chrix in ACCB for empty test
        add xl,ACCA
        inc ACCA
        andi ACCA,63
        sts chrix,ACCA ; this points to the next character in msgbuff
        ld ACCA,X
        cpi ACCA,126
        brne notild
        ret
;
notild: cpi ACCA,123
		brsh getciv ; invalid character
        cpi ACCA,0x20
        brsh getcix2
getciv: sts chrix,zreg ; start again from beginning of msgbuf...
; toggle pC4 for each message
        in xl,PORTC
	    ldi xh,(1<<TOGGLE)
	    eor xl,xh
	    out PORTC,xl	; toggle line completed io bit
; do buffer empty test
        tst ACCB
        brne getcix
        ldi ACCA,'?' ; empty buffer ... shouldn't happen
;
getcix2: cpi ACCA,'^'
		brne gc2
		ldi ACCA,0x27
		sbic PINA,7
		ldi ACCA,0x60
gc2:	 sbrc PBCpy,4 ; b4 is prog mode
         out UDR,ACCA
		 ldz (cset1<<1)
		 lds ACCB,csel
		 cpi ACCB,'2'
		 brne usecsel1
		 ldz (cset2<<1)
usecsel1:  mov ACCB,ACCA ; keep ACCA for return value
         subi ACCB,0x20 ; max 122-32=90
        
         lsl ACCB  ; addon 6 times same as *2 added on three times
         add zl,ACCB
         adc zh,zreg
          add zl,ACCB
         adc zh,zreg
		  add zl,ACCB
         adc zh,zreg
	    ret
;
; if <cr>, ignore if sending 
Rxint:	push	ACCA
	in	ACCA,SREG	 
	push	ACCA
	push	ACCB
	push	XL
	push	XH
	in ACCB,UCSRA
	in ACCA,UDR
; this should only be active when  bit of SERIAL is 1
    sbrs PBCpy,4 ; only enable receive if PB4 is 0
	rjmp rx2	;	yes
	cbi UCSRB,7	; disable RXCIE
	rjmp sout
;
rx2:	sbrc SERIAL,GOTLINE ; live mode
	rjmp sout ; allready have stuff
;
srcnt: sbrc SERIAL,ECHOM  ; busy sending.. ignore rx
	rjmp sout
;
;
sr2: 	sbrc	ACCB,FE
 	rjmp	sout	; framing error
	sbrc	ACCB,DOR
	RJMP	sout	; overrun error
    
	cpi	ACCA,123 ; 'z'+1
    brlo   sr22
    cpi ACCA,126
    brne	sout
    rjmp    notdel

sr22: lds XL,rxbuf
	cpi XL,'!'
	brne sr3
	cpi	ACCA,97
	brlo	sr3
	andi	ACCA,0b11011111	; convert 61h to 41h
sr3:	cpi	ACCA,0x08	; del?
	brne	notdel
	lds	ACCB,rxcnt		; get count
	tst 	ACCB
	breq	dontinc ; send a bell
	dec	ACCB
	sts	rxcnt,ACCB
	rjmp	notcr	; echo 0x08
;
notdel: ldi	XL,LOW(rxbuf)		; point to rxbuf
	ldi	XH,HIGH(rxbuf)
	lds	ACCB,rxcnt		; get count
	cpi	ACCB,50
	brsh	dontinc2
	add	XL,ACCB			; make address
	cpi ACCA,0x0d
	breq iscr
	cpi ACCA,0x20
	brlo sout ; don't echo (or store) below 0x20
	st	X,ACCA	; store in buffer
	inc	ACCB	; bump counter
	sts	rxcnt,ACCB ; store it again
	rjmp notcr
;
iscr: 	st   X,ZREG	; replace <cr> with 0
	sbr  SERIAL,(1<<GOTLINE)	; yes, set SERIAL
	rjmp notcr
;
dontinc: sts rxbuf,ZREG
dontinc2: ldi	ACCA,0x07	; errbeep	
notcr: 	out     UDR,ACCA	; echo
;
Sout:	pop	XH
	pop	XL
	pop	ACCB
	pop	ACCA
	OUT	SREG,ACCA
	pop	ACCA
	RETI


TXdre:	push	ACCA
	in	ACCA,SREG	 
	push	ACCA
	push	ACCB
	push	XL
	push	XH
;
	
; this in should only be active when ECHOM bit of SERIAL is 1
dre2:	sbrs SERIAL,ECHOM ; echo send msg buffer
	rjmp disint2
	lds ACCA,lastchr
	cpi ACCA,0x0d
	breq disint
    ldi XH,HIGH(msgbuff)
	mov XL,TXOPT
    
	ld ACCA,X+
    mov TXOPT,xl
	cpi ACCA,0x20
	brsh oksnd
	ldi ACCA,0x0d
oksnd: out UDR,ACCA
	sts lastchr,ACCA
	rjmp udout
;
disint:  cbr  SERIAL,(1<<GOTLINE)
disint2: cbr SERIAL,(1<<ECHOM)	; no longer echo
	cbi UCSRB,5 ; disable txbuffer empty int
	sts rxcnt,ZREG	; remove any message received while send
	mov TXOPT,ZREG ; 
	sts lastchr,ZREG

udout: 	pop	XH
	pop	XL
	pop	ACCB
	pop	ACCA
	OUT	SREG,ACCA
	pop	ACCA
	RETI
;
;
sendmmsg: cli
        ldi TXOPT,LOW(msgbuff)
        rjmp sm002
sendemsg: cli
        ldi TXOPT,LOW(eebuff)
        rjmp sm002
sendiz: cli
       ldy tbuff
        mov TXOPT,yl
sndizl:  lpm ACCA,Z+
       st Y+,ACCA
       cpi ACCA,0x20
       brsh sndizl
       st Y+,zreg
sendtmsg: cli 
         ldi TXOPT,low(tbuff)
sm002: sts lastchr,FFREG
	sbr SERIAL,(1<<ECHOM)
	sbi UCSRB,5	; allow UDRE int to send stored message
	sei
	ret
;
livemode: lds ACCA,rxbuf
	cpi ACCA,'!'
	breq loop2	; look for !SAVE or !TEST or !RESET
	cpi ACCA,'?'
	brne lm2
	lds ACCA,rxbuf+1
	cpi ACCA,0x20
	brsh nocmd
	rcall showstat2
    rcall showhex
	rcall sendtmsg
	rjmp nocom
;
lm2: lds ACCA,rxbuf
	cpi ACCA,0x20
	brlo echo
	rcall copymsg	; copy rxbuf to msgbuf
    sts chrix,zreg
   sbr STAT,(1<<b_NXTCHR)
;
echo:	rcall echomsg	; copy msgbuff to TBUFF
	rcall sendtmsg
	rjmp nocom
invcom: ldz messhlp<<1 ; : .db "Type in message, then !SAVE",0x0d	; term with 0 for DRE
invcm2: rcall sendiz
	rjmp nocom
;
nom2s: ldz messnone<<1 ; .db "No message to save?",0x0d
	rjmp invcm2

sendcom:ldz messcmd<<1 ; .db "!LOAD or !TEST or !RESET or !SAVE",0x0d
	rjmp invcm2

loop2:	lds ACCA,rxbuf+1
	cpi ACCA,'C' ; this should be 'C'
	brlo sendcom
	rcall parse
	tst ACCA
	breq invcom	; no command found
	cpi ACCA,3	; !RESET
	brne try2
	rjmp wtreset
;
try2:	cpi ACCA,2	; !TEST
	brne try1
	rcall testmsg ; do test
	rjmp echo
;
try1: 	cpi ACCA,1	; !SAVE
	brne try4
	lds ACCA,msgbuff
	cpi ACCA,0x20	; first char must be >=space
	brlo nom2s ; no message to save
	rcall savstat
	rcall savee	; do message save

;
eloadok: rcall sendmmsg
;
nocom:	sts rxcnt,ZREG	; should have cli here
	sts rxbuf,ZREG
	cbr SERIAL,(1<<GOTLINE)	; clear <cr>
	RET 
;
nocmd: ldz sendqt<<1
	rjmp invcm2
;
try4: 	cpi ACCA,4	; !LOAD
	brne try5
	rcall lodstat ; will rcall setqrs
	rcall loadee	; this will enable ints
	cpi ACCA,1
	breq eloadok		
	cpi ACCA,0xff
	brne nocomss 
; severe error loadee will have no message!! ONCE only
	ldz messnl<<1
    rcall sendiz
nocomss:    rjmp nocom
;
try5: cpi ACCA,5 ; !CSET=
	brne try6
	lds ACCA,rxbuf+7
	cpi ACCA,0x20
	brsh nocmd
	lds ACCA,rxbuf+6
	cpi ACCA,'1'
	brne try52
setcsel:	sts csel,ACCA
sndok: ldz messok<<1
	rjmp invcm2
try52:	cpi ACCA,'2'
	brne nocmd
	ldz cset2<<1
	lpm ACCB,Z
	tst ACCB
	breq nocmd
	andi ACCB,0x0f ; mod mv4
	cpi ACCB,6
	brsh nocmd
	rjmp setcsel ; exit via invcm2,nocom
;
try6: cpi ACCA,6 ;!TILT=
	brne try7
	mov TILT,ZREG
	ldi ACCA,0x30
	sts QRS,ACCA
	rcall setqrs
	lds ACCA,rxbuf+6
	cpi ACCA,'-'
	brne trytpos
	lds ACCA,rxbuf+8
	cpi ACCA,0x20
	brsh nocmd
	ldi ACCA,0x80
	mov TILT,ACCA ; set -ve flag
	lds ACCA,rxbuf+7
	rjmp trytp2
trytpos: lds ACCA,rxbuf+7
	cpi ACCA,0x20
	brsh nocmdss	
	lds ACCA,rxbuf+6
trytp2: cpi ACCA,'0'
	brne tryp01
	mov TILT,zreg
	rjmp sndok ; reset TILT if TILT=0
tryp01: cpi ACCA,'1'
	brlo nocmdss
	cpi ACCA,'4'
	brlo trytp3 ; allow 1,2,3
	mov TILT,zreg
nocmdss:	rjmp nocmd
trytp3:	subi ACCA,0x30
	or TILT,ACCA
	rjmp sndok


try7: cpi ACCA,7 ;!SLOW=
	brne try8 ;nocmdss
    lds ACCA,rxbuf+7
	cpi ACCA,0x20
	brsh nocmdss	
	lds ACCA,rxbuf+6
	cpi ACCA,'0'
	brlo nocmdss
	cpi ACCA,'5'
	brsh nocmdss
    sts QRS,ACCA
	rcall setqrs
	rjmp sndok
;
try8: cpi ACCA,8 ;!CHAR= six in hex comma sep
	brne nocmdss
;;	ldy rxbuf+6
;;	ldx tbuff
;;	rcall show6
;;	rcall sendtmsg
;;	rjmp  nocom
	
    ldx rxbuf+6 ;src, first digit after the ","
    ldz tildebuf ;dest
    ldi COUNT1,5 ; make six bytes at tildebuf
try8l:    rcall gthex ; make a byte from one or two chars in rxbuf

    brcc try8fail ; ret NC failed
    st Z+,ACCA ; store at tildebuf

    ld ACCA,X+ ; get , sep
    dec COUNT1
     breq try8fin ; last one is at end of line
	cpi ACCA,0x2c ; ',' ; first five end with ','
	breq try8l
try8fail: sts tildebuf,zreg
         rjmp nocmdss
;    
try8fin: rcall gthex ; make a byte from one or two chars in rxbuf
		brcc try8fail
       st Z+,ACCA ; store at tildebuf
	   ld ACCA,X+ ; get , sep
	   cpi ACCA,0x20
	   brsh try8fail
      rjmp sndok

		 
	
gthex: ld ACCA,X+ ; get MSB/LSB
       cpi ACCA,0x30
       brlo gthfail ; fail <0
       cpi ACCA,0x3a
       brlo gth2 ; is 0...9,ok
       cpi ACCA,'A'
       brlo gthfail ;<A fail
       cpi ACCA,'G'
       brsh gthfail ;>F fail
       subi ACCA,7 ; now A is 58
gth2:  subi ACCA,48 ; 0x30
       andi ACCA,15
       ld ACCB,X ; inspect without inc X
       cpi ACCB,0x2c +1; ','
       brLO gthout ; only one hex digit for this byte, ret in ACCA
;
       swap ACCA ; high nibble
       ld ACCB,X+ ; must inc X
       cpi ACCB,0x30
       brlo gthfail ; <0 fail
       cpi ACCB,0x3a
       brlo gth3  ; is 0..9,ok
       cpi ACCB,'A'
       brlo gthfail ; <A fail
       cpi ACCB,'G'
       brsh gthfail  ; >F fail
       subi ACCB,7 ; now A is 58
gth3:  subi ACCB,48 ; 0x30
       andi ACCB,15
       or ACCA,ACCB
gthout: sec ; C ok
     ret
gthfail: clc ; NC fail
         ret
;
hxtab: .db "0123456789ABCDEF"
hxnibs: ld ACCA,Y+
        mov ACCB,ACCA
        swap ACCA
        andi ACCA,0x0f
        breq hxn2 ; don't print MSnibble if zero
        ldz hxtab<<1
        add zl,ACCA
        adc zh,zreg
        lpm ACCA,Z
        st X+,ACCA
hxn2:   andi ACCB,15
        ldz hxtab<<1
        add zl,ACCB
        adc zh,zreg
        lpm ACCA,Z
        st X+,ACCA
        ret
;
showhex: lds ACCA,tildebuf
         tst ACCA
         brne shx2
shx1:    st X+,zreg
         ret
shx2:   ldy tildebuf
        ldi ACCA,0x20
       st X+,ACCA
       ldi ACCA,'~'
       st X+,ACCA
        ;
show6:       ldi COUNT1,6
shxlp:  rcall hxnibs
        dec COUNT1
        breq shx1
shx0:   ldi ACCA,','
        st X+,ACCA
        rjmp shxlp

echomt: ldi ZH,HIGH(rxbuf)
	ldi ZL,LOW(rxbuf)
	ldi yh,HIGH(tbuff) ; point to send message
	ldi yl,LOW(tbuff)
	rjmp copy02
echomsg: ldi ZH,HIGH(msgbuff)
	ldi ZL,LOW(msgbuff)
	ldi yh,HIGH(tbuff) ; point to send message
	ldi yl,LOW(tbuff)
	rjmp copy02
;
copyemsg: ldi ZH,HIGH(eebuff)
	ldi ZL,LOW(eebuff)
	rjmp copy01
; copy rxbuf to msgbuf
copymsg: ldi ZH,HIGH(rxbuf)
	ldi ZL,LOW(rxbuf)
copy01:	ldi YH,HIGH(msgbuff) ; point to send message
	ldi YL,LOW(msgbuff)
copy02:	clr COUNT1
;
cstm02:	ld ACCA,Z+
	andi ACCA,0x7f
	cpi ACCA,0x20	; end of message?
	brsh cst2
	clr ACCA	; anything less than 0x20 becomes 0
cst2:	cpi ACCA,0x20	; end of message?
	brlo cdfin
;
	st Y+,ACCA
	inc COUNT1
	cpi COUNT1,50
	brlo cstm02
cdfin:	st Y+,ZREG	; mark end of message
     	ret
;

; test A...Z 0...9 and testchrs
testchrs: .db " .&#@$%/!? ", 0
testmsg: ldi ACCA,'A'
	ldy msgbuff ; point to send message
	ldi ACCB,0x20
tm01:	st Y+,ACCA	; A...Z
	inc ACCA
	cpi ACCA,'Z'+1
	brlo tm01
tm02:   st Y+,ACCB
	ldi ACCA,0x30 ; 0...9
tm03:	st Y+,ACCA
	inc ACCA
	cpi ACCA,'9'+1
	brlo tm03
    ldz (testchrs<<1)
tm04: lpm ACCB,Z+
	st Y+,ACCB
    tst ACCB
    brne tm04	; mark end of message with 0, message shouldn't be more than 50 chars
    sts chrix,zreg ; ensure send from start
   sbr STAT,(1<<b_NXTCHR)
	ret

; parse
 

;
parse: ldy (m_save<<1)
	ldi TEMP1,1
parse2: mov ZH,yh ;HIGH(m_save)
	mov ZL,yl ;LOW(m_save)
    lpm ACCB,Z
	tst ACCB
    breq pend ; end of table reached
	rcall pchk
	brne pnope
	mov ACCA,TEMP1
	ret

pnope: adiw yl,6
      inc TEMP1
      cpi TEMP1,9
      brlo parse2
pend: clr ACCA
      ret

;
pchk:	ldi XH,HIGH(rxbuf)
	ldi XL,LOW(rxbuf)
	adiw XL,1 ; move to chracter after the !
pchk2:	ld ACCA,X+  ; msgbuf
	lpm ACCB,Z+ ; commands
	tst ACCB 
	brne pchk3
	tst ZREG
	ret ; Z	reached end of command
pchk3:  cp ACCA,ACCB
	breq pchk2
pfail:	tst FFREG
	ret ; with NZ
;
; eeprom ROUTINES
;
loadee:	sts EPAGE,ffreg
		rcall getead	; TEMP2:TEMP1
	rcall eerb
	cpi ACCA,'h'
	breq le01
	ldi ACCA,0xff	; fail
	ret
;
lodstat:  sts EPAGE,zreg
         rcall getead
         ldi COUNT1,8
         ldx eebuff
         rcall erd2
         tst ACCA
         brne lodstok
         ret
lodstok: ldx eebuff
         ld ACCA,X+
         cpi ACCA,'#'
         brne eerf
         ld ACCA, X+
         andi ACCA,0x87
         mov TILT,ACCA
         
         ld ACCA,X+
		 sts CSEL,ACCA
         ld ACCA,X+
         sts QRS,ACCA
		 tst TILT
		 breq lsk02
		 ldi ACCA,0x30 ; TILT .nz. must clear QRS
		 sts QRS,ACCA
lsk02:   rjmp setqrs ;ret ; should be x30..0x34

le01:	ldi XH,HIGH(eebuff)
	ldi XL,LOW(eebuff)
	ldi COUNT1,52 ; max bytes to read
erd2:	clr ACCB
eerd:   rcall eerb
	cpi ACCA,0x80
	brsh eerf
	st X+,ACCA
	add ACCB,ACCA
	tst ACCA 	; 0 is end
	breq eoeerd
	tst COUNT1
	brne eerd
eerf:	clr ACCA ; failure
	ret
;
eoeerd:	rcall eerb	; read the check
	cp ACCB,ACCA
	breq eeok
; in the case checks sum failed, flag store as invalid	
	rcall getead
	ser  ACCA	;0xff last longer?
	rcall eewb	; inc TEMP1, decr COUNT1
	rjmp eerf
;
eeok: rcall copyemsg ; copy from eebuf to msgbuf
	ldi ACCA,1
	ret
;
savstat: ldx eebuff
         ldi ACCA,'#'
         st X+,ACCA
         mov ACCA,TILT
         ori ACCA,0x30
         st X+,ACCA
         lds ACCA,CSEL
         st X+,ACCA
         lds ACCA,QRS
         st X+,ACCA
         st X+,zreg
         sts EPAGE,zreg
         rcall getead
         ldi COUNT1,8
         ldx eebuff
         rjmp ewr2
;
savee:	sts EPAGE,ffreg
		rcall getead	; into TEMP2:TEMP1
    ldi ACCA,'h'
	rcall eewb	; save 'h' as first
	ldi XH,HIGH(msgbuff)
	ldi XL,LOW(msgbuff)
	ldi COUNT1,52 ; max bytes to write
ewr2:	clr ACCB
eewr:	ld ACCA,X+
	add ACCB,ACCA
	rcall eewb
	tst ACCA 	; 0 is end
	breq eoeew
	tst COUNT1
	brne eewr
	mov ACCA,ZREG
	rcall eewb
eoeew:	mov ACCA,ACCB
	rcall eewb	; write the check
	ret
;
; get EEPROM addr,could use spare i/p bits to select message address
getead:	ldi TEMP1,0x00 ; select xxxx xabc
	lds TEMP2,EPAGE
	cpse TEMP2,zreg
	ldi TEMP1,0x01 ;if EPAGE is 0, then TEMP1 is zero
	mov TEMP2,ZREG
	swap TEMP1
	andi TEMP1,0x70 ;  xabc 0000
	lsl TEMP1	;  ab00 0000
	rol TEMP2
	lsl TEMP1	;a bc00 0000
	rol TEMP2
	ret
;
eewb:	sbic EECR,EEWE
	rjmp eewb
	wdr
	in TTEMP,SREG
	cli
	out EEARH,TEMP2
	out EEARL,TEMP1
	out EEDR,ACCA
	sbi EECR,EEMWE
	sbi EECR,EEWE
	inc TEMP1	; address
	dec COUNT1 ; counter
	out SREG,TTEMP ;	sei
	ret
;
eerb:	sbic EECR,EEWE
	rjmp eerb
	wdr
	in TTEMP,SREG	;
	cli
	out EEARH,TEMP2
	out EEARL,TEMP1
	sbi EECR,EERE
	in ACCA,EEDR
	inc TEMP1	; address
	dec COUNT1 ; counter
	out SREG,TTEMP ; sei
	ret
;
   .org $0C80
m_save:	.db "SAVE",0,0	;1
m_test: .db "TEST",0,0	;2
m_reset: .db "RESET",0 ;3
m_load: .db "LOAD",0,0 ;4
m_cset: .db "CSET=",0 ;5
m_tilt: .db "TILT=",0; 6
m_slow: .db "SLOW=",0 ; 7
m_tild: .db "CHAR=", 0 ; 8
		.dw 0 
   .org $0D00
messcmd: .db "!LOAD !TEST !RESET !SAVE !CSET= !SLOW= !TILT= or ?",0x0d
messhlp: .db "Type in message, then !SAVE",0x0d	; term with 0 for DRE
messnone: .db "No message to save?",0x0d
messnl: .db "No EE message found", 0x0d
messok: .db "ok", 0x0d
sendqt: .db "?",0x0d
 
 .ORG $0E80
; this table counts '1's in data and divides 100 by the number of '1's
; but single pixel columns are 100mS 
bctab100: .db 100,100 ;00000 0      ; .db 100  ;00001 1
       .db 100,50  ;00010    ; .db 50  ;00011
       .db 100,50   ;00100  ; .db 50   ;00101
       .db 50,33  ;00110  ; .db 33  ;00111
       .db 100,50   ;01000 8  ; .db 50  ;01001
       .db 50,33  ;01010 ;  .db 33  ;01011
       .db 50,33    ;01100 ;  .db 33   ;01101
       .db 33,25  ;01110 ;  .db 25  ;01111 15
       .db 100,50  ;10000 16 ;  .db 50  ;10001
       .db 50,33    ;10010 ;  .db 33   ;10011
       .db 50,33   ;10100 ;  .db  33   ;10101
       .db 33,25   ;10110 ;  .db 25   ;10111
       .db  50,33  ;11000 24 ;  .db 33   ;11001
       .db  33,25  ;11010 ;  .db  25 ;11011
       .db 33,25   ;11100 ;  .db  25  ;11101
       .db  25,20  ;11110 ;  .db  20  ;11111 31
; and again
      .db 100,50  ;100000 0  .db 50  ;100001 1
       .db 50,33  ;100010 .db 33  ;100011
       .db 50,33   ;100100 .db 33   ;100101
       .db 33,25  ;100110 .db 25  ;100111
       .db 50,33   ;101000 8 .db 33 ;101001
       .db 33,25  ;101010  .db 25 ;101011
       .db 33,25   ;101100  .db 25   ;101101
       .db 25,20  ;101110  .db 20  ;101111 15
       .db 50,33  ;110000 16  .db 33  ;110001
       .db 33,25   ;110010  .db 25 ;110011
       .db 33,25   ;110100  .db  25   ;110101
       .db 25,20  ;110110  .db 20  ;110111
       .db 33,25  ;111000 24  .db 25   ;111001
       .db 25,20  ;111010  .db  20 ;111011
       .db 25,20   ;111100  .db  20  ;111101
       .db 20,20  ;111110  .db  20  ;111111 63 - invalid	   
 
 ; don't need this    .org $1000 is inside the include file  
 ; each char is 6 bytes. first byte is number of columns to follow (0=invalid,skip)
      ; top bit of each column is set draw up 
      ; for each column, b5...b0 are the pixel data, b0 is lowermost (at 010)

; cset2 draws some columns slanting from upper left to lower right
; b0 of pixel data is  D/A code of 2 and is generally unused (this is one above _ code 001)
; 
; don't need this:
  
 .org $1000 ; is inside the include file
 cset2: 
;.include "cset2.asm" 

